/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.UniversalPosition;
import java.util.EnumSet;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EntityInsectFourteen
extends EntityDivineMonster {
    public EntityInsectFourteen(EntityType<? extends EntityDivineMonster> type, Level worldIn) {
        super(type, worldIn);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.ENDIKU.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.INSECT_FOURTEEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.INSECT_FOURTEEN_HURT.get();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FloatEnemyGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static class FloatEnemyGoal
    extends Goal {
        protected final Mob mob;
        protected Path path;
        protected double pathedTargetX;
        protected double pathedTargetY;
        protected double pathedTargetZ;
        protected long lastCanUseCheck;
        protected int ticksUntilNextPathRecalculation;
        protected int ticksUntilNextAttack;
        protected int failedPathFindingPenalty;
        protected int attackTimer;
        protected boolean canPenalize = false;

        public FloatEnemyGoal(Mob entity) {
            this.mob = entity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            long i = this.mob.level().getGameTime();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.getNavigation().createPath(UniversalPosition.toBlockPos(livingentity.position().offsetRandom(this.mob.getRandom(), 3.0f)), 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.getNavigation().createPath(UniversalPosition.toBlockPos(livingentity.position().offsetRandom(this.mob.getRandom(), 3.0f)), 0);
            return this.path != null || this.mob.distanceToSqr((Entity)livingentity) < 25.0;
        }

        public boolean canContinueToUse() {
            Player player;
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            return !(livingentity instanceof Player) || !(player = (Player)livingentity).isSpectator() && !player.isCreative();
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.path, 1.0);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void stop() {
            LivingEntity livingentity = this.mob.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.mob.setTarget(null);
            }
            this.mob.setAggressive(false);
            this.mob.getNavigation().stop();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.mob.getTarget();
            if (livingentity == null) {
                return;
            }
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            if (this.ticksUntilNextPathRecalculation > 0) {
                --this.ticksUntilNextPathRecalculation;
            } else if (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                double d0 = this.mob.distanceToSqr((Entity)livingentity);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.getNavigation().getPath() != null ? ((finalPathPoint = this.mob.getNavigation().getPath().getEndNode()) != null && livingentity.distanceToSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.getNavigation().moveTo((Entity)livingentity, 1.0)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            if (this.ticksUntilNextAttack > 0) {
                --this.ticksUntilNextAttack;
            } else {
                this.checkAndPerformAttack(livingentity);
            }
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.mob.isAggressive()) {
                Vec3 v;
                double distancesquared;
                if ((this.mob.tickCount & 1) == 0 && (distancesquared = (v = target.position().subtract(this.mob.position())).lengthSqr()) < 25.0) {
                    v = v.scale(9.0 / v.lengthSqr());
                    target.setDeltaMovement(this.mob.position().add(v.x, 4.2, v.y).subtract(target.position()).scale(0.1).add(target.getDeltaMovement()));
                    target.hasImpulse = true;
                    if (target instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)target;
                        serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
                    }
                }
                if (this.attackTimer < 1) {
                    this.mob.setAggressive(false);
                    this.ticksUntilNextAttack = this.adjustedTickDelay(20);
                } else {
                    --this.attackTimer;
                }
            } else if (this.mob.getSensing().hasLineOfSight((Entity)target)) {
                this.attackTimer = 40;
                this.mob.setAggressive(true);
            }
        }
    }
}

