/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.vethea;

import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;

public class EntityKazrotic
extends EntityDivineMonster
implements RangedAttackMob {
    public EntityKazrotic(EntityType<? extends EntityKazrotic> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.25, 15, 40.0f));
        super.registerGoals();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (this.isAlive() && this.getTarget() != null && !this.level().isClientSide) {
            ThrowableProjectile projectile = (ThrowableProjectile)((EntityType)EntityRegistry.KAZROTIC_SHOT.get()).create(this.level());
            projectile.setOwner((Entity)this);
            projectile.setPos(this.getEyePosition());
            double d0 = this.getTarget().getX() - this.getX();
            double d1 = this.getTarget().getY(0.3333333333333333) - projectile.getY();
            double d2 = this.getTarget().getZ() - this.getZ();
            double d3 = Math.sqrt((float)(d0 * d0 + d2 * d2));
            projectile.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 0.8f);
            this.level().addFreshEntity((Entity)projectile);
        }
    }

    public boolean hurt(DamageSource par1, float par2) {
        if (par1.is(DamageTypes.EXPLOSION)) {
            return false;
        }
        return super.hurt(par1, par2);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.KAZROTIC.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.KAZROTIC_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.KAZROTIC_HURT.get();
    }
}

