/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.wildwood;

import divinerpg.entities.base.EntityDivineNeutral;
import divinerpg.registries.SoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;

public class EntityEpiphite
extends EntityDivineNeutral {
    public EntityEpiphite(EntityType<? extends EntityEpiphite> type, Level worldIn) {
        super((EntityType<? extends EntityDivineNeutral>)type, worldIn);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(Entity target) {
        boolean attack = super.doHurtTarget(target);
        if (attack & this.random.nextInt(5) == 0) {
            LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, this.level());
            bolt.setPos(target.getX(), target.getY(), target.getZ());
            if (!this.level().isClientSide) {
                this.level().addFreshEntity((Entity)bolt);
            }
        }
        return attack;
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.GROWL.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }
}

