/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import com.mojang.blaze3d.systems.RenderSystem;
import divinerpg.attachments.Arcana;
import divinerpg.config.ClientConfig;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;

@EventBusSubscriber(modid="divinerpg", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ArcanaRenderer
implements LayeredDraw.Layer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/gui/arcana_bar.png");
    private static final ResourceLocation LOC = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"arcana_bar");
    static long counter = 180L;
    static float previousAmount = 0.0f;

    @SubscribeEvent
    public static void registerGUI(RegisterGuiLayersEvent event) {
        event.registerBelowAll(LOC, (LayeredDraw.Layer)new ArcanaRenderer());
    }

    public void render(GuiGraphics gui, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.options.hideGui && mc.gameMode.getPlayerMode() != GameType.SPECTATOR) {
            mc.getProfiler().push("arcBar");
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            int windowWidth = mc.getWindow().getGuiScaledWidth();
            int windowHeight = mc.getWindow().getGuiScaledHeight();
            int xLocation = windowWidth - ClientConfig.Values.ARCANA_BAR_POS_X;
            int yLocation = windowHeight - ClientConfig.Values.ARCANA_BAR_POS_Y;
            if (ClientConfig.Values.HIDE_ARCANA_BAR) {
                float arcana = Arcana.getAmount((LivingEntity)mc.player);
                if (previousAmount != arcana) {
                    previousAmount = arcana;
                    counter = mc.level.getGameTime() + 40L;
                }
                if (counter - mc.level.getGameTime() > 0L) {
                    gui.blit(TEXTURE, xLocation, yLocation, 0, 0, 100, 9);
                    gui.blit(TEXTURE, xLocation, yLocation, 0, 9, (int)(arcana / Arcana.getMaxArcana((LivingEntity)mc.player) * 100.0f), 18);
                }
            } else {
                gui.blit(TEXTURE, xLocation, yLocation, 0, 0, 100, 9);
                gui.blit(TEXTURE, xLocation, yLocation, 0, 9, (int)(Arcana.getAmount((LivingEntity)mc.player) / Arcana.getMaxArcana((LivingEntity)mc.player) * 100.0f), 18);
            }
            mc.getProfiler().pop();
        }
    }
}

