/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.effect.mob.armor.ArmorEffectInstance;
import divinerpg.effect.mob.armor.UpdatableArmorEffect;
import divinerpg.items.base.ItemDivineArmor;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.MobEffectRegistry;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class ArmorAbilitiesEvent {
    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.level().isClientSide()) {
            EquipmentSlot slot = event.getSlot();
            if (slot.isArmor()) {
                ItemStack s = event.getFrom();
                Holder<MobEffect>[] holderArray = s.getItem();
                if (holderArray instanceof ItemDivineArmor) {
                    ItemDivineArmor armor = (ItemDivineArmor)holderArray;
                    if (!s.is(event.getTo().getItem()) && armor.supportedEffects != null) {
                        for (Holder<MobEffect> effect : armor.supportedEffects) {
                            entity.removeEffect(effect);
                        }
                    }
                }
                ArmorAbilitiesEvent.updateAbilities((ResourceKey<Level>)entity.level().dimension(), entity);
            } else {
                ArmorAbilitiesEvent.updateEffects((ResourceKey<Level>)entity.level().dimension(), entity);
            }
        }
    }

    public static void updateEffects(ResourceKey<Level> level, LivingEntity entity) {
        for (MobEffectInstance instance : entity.getActiveEffects()) {
            Object object = instance.getEffect().value();
            if (!(object instanceof UpdatableArmorEffect)) continue;
            UpdatableArmorEffect update = (UpdatableArmorEffect)object;
            update.update(level, entity);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateAbilities(ResourceKey<Level> level, LivingEntity entity) {
        boolean fullArmor;
        void var8_13;
        ArrayList<Holder<MobEffect>> supportedEffects = new ArrayList<Holder<MobEffect>>();
        ArrayList<Integer> amplifiers = new ArrayList<Integer>();
        ItemStack[] stack = new ItemStack[]{entity.getItemBySlot(EquipmentSlot.HEAD), entity.getItemBySlot(EquipmentSlot.CHEST), entity.getItemBySlot(EquipmentSlot.LEGS), entity.getItemBySlot(EquipmentSlot.FEET)};
        ArrayList<ItemDivineArmor> equipment = new ArrayList<ItemDivineArmor>();
        ItemStack[] itemStackArray = stack;
        int n = itemStackArray.length;
        boolean bl = false;
        while (var8_13 < n) {
            ItemStack s = itemStackArray[var8_13];
            Item item = s.getItem();
            if (item instanceof ItemDivineArmor) {
                ItemDivineArmor armor = (ItemDivineArmor)item;
                equipment.add(armor);
            }
            ++var8_13;
        }
        for (ItemDivineArmor armor : equipment) {
            if (armor.supportedEffects == null) continue;
            for (int i = 0; i < armor.supportedEffects.length; ++i) {
                Holder<MobEffect> supportedEffect = armor.supportedEffects[i];
                if (supportedEffects.contains(supportedEffect)) continue;
                supportedEffects.add(supportedEffect);
                amplifiers.add(armor.amplifier == null ? 0 : armor.amplifier[i]);
            }
        }
        boolean bl2 = fullArmor = equipment.size() == 4;
        if (fullArmor) {
            void var8_16;
            ArmorMaterial mat = (ArmorMaterial)((ItemDivineArmor)equipment.getFirst()).getMaterial().value();
            boolean bl3 = true;
            while (fullArmor && var8_16 < 4) {
                fullArmor = ((ItemDivineArmor)equipment.get((int)var8_16)).getMaterial().value() == mat;
                ++var8_16;
            }
            if (fullArmor) {
                void var8_18;
                boolean bl4 = false;
                while (var8_18 < supportedEffects.size()) {
                    MobEffectInstance instance;
                    Holder supportedEffect = (Holder)supportedEffects.get((int)var8_18);
                    boolean shouldRemove = false;
                    if (!entity.hasEffect(supportedEffect) || (shouldRemove = !(instance = entity.getEffect(supportedEffect)).isInfiniteDuration() || !(instance instanceof ArmorEffectInstance))) {
                        if (shouldRemove) {
                            entity.removeEffect(supportedEffect);
                        }
                        entity.addEffect((MobEffectInstance)new ArmorEffectInstance((Holder<MobEffect>)supportedEffect, (Integer)amplifiers.get((int)var8_18)));
                    } else {
                        Object object = supportedEffect.value();
                        if (object instanceof UpdatableArmorEffect) {
                            UpdatableArmorEffect update = (UpdatableArmorEffect)object;
                            update.update(level, entity);
                        }
                    }
                    ++var8_18;
                }
            }
        }
        if (!fullArmor) {
            for (Holder holder : supportedEffects) {
                if (!entity.hasEffect(holder) || !entity.getEffect(holder).isInfiniteDuration()) continue;
                entity.removeEffect(holder);
            }
        }
    }

    @SubscribeEvent
    public void onEffectRemoved(MobEffectEvent.Remove event) {
        Holder e = event.getEffect();
        if (e.is(MobEffectRegistry.SENG_FUR_STRENGTH.getKey()) || e.is(MobEffectRegistry.WILDWOOD_HEAL.getKey()) || e.is(MobEffectRegistry.ANGELIC_FLIGHT.getKey())) {
            ((MobEffect)e.value()).onMobRemoved(event.getEntity(), 0, null);
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        float amount = event.getNewDamage();
        Entity entity = event.getSource().getEntity();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            if (source.is(DamageTypes.PLAYER_ATTACK)) {
                if (attacker.hasEffect(MobEffectRegistry.HALITE_STRENGTH)) {
                    event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)16.0f, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                } else if (attacker.hasEffect(MobEffectRegistry.DIVINE_STRENGTH) || attacker.hasEffect(MobEffectRegistry.DEMONIZED_HELMET)) {
                    event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)6.0f, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                } else if (attacker.hasEffect(MobEffectRegistry.GLISTENING_HELMET)) {
                    event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)3.0f, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                } else if (attacker.hasEffect(MobEffectRegistry.SENG_FUR_STRENGTH)) {
                    event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)2.0f, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                } else if (attacker.hasEffect(MobEffectRegistry.TORMENTED_HELMET)) {
                    event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)9.0f, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                } else if (attacker.hasEffect(MobEffectRegistry.AWAKENED_HALITE_STRENGTH)) {
                    event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)20.0f, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                }
            } else if ((attacker.hasEffect(MobEffectRegistry.AWAKENED_HALITE_STRENGTH) || attacker.hasEffect(MobEffectRegistry.CORRUPTED_STRENGTH)) && (source.is(DamageTypes.MOB_PROJECTILE) || source.is(DamageTypes.ARROW) || source.is(DamageTypes.THROWN) || source.is(DamageTypes.TRIDENT))) {
                event.setNewDamage(amount * 1.5f);
            }
        }
        if (target instanceof Player) {
            if (target.hasEffect(MobEffectRegistry.PROJECTILE_PROTECTION) && (source.is(DamageTypes.MOB_PROJECTILE) || source.is(DamageTypes.ARROW) || source.is(DamageTypes.THROWN) || source.is(DamageTypes.TRIDENT))) {
                event.setNewDamage(amount * 0.34f);
            } else if (target.hasEffect(MobEffectRegistry.MELEE_PROTECTION) && (source.is(DamageTypes.MOB_ATTACK) || source.is(DamageTypes.PLAYER_ATTACK) || source.is(DamageTypes.GENERIC)) && !source.is(DamageTypes.MOB_PROJECTILE)) {
                event.setNewDamage(amount * 0.67f);
            } else if (target.hasEffect(MobEffectRegistry.SENG_FUR_STRENGTH)) {
                event.setNewDamage(amount * 0.7f);
            } else if (target.hasEffect(MobEffectRegistry.DEGRADED_HOOD) && source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.DEGRADED_HELMET) && !source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.DEGRADED_MASK) && source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC)) {
                event.setNewDamage(amount * 0.82f);
            } else if (target.hasEffect(MobEffectRegistry.FINISHED_HOOD) && source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.FINISHED_HELMET) && !source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.FINISHED_MASK) && source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC)) {
                event.setNewDamage(amount * 0.773f);
            } else if (target.hasEffect(MobEffectRegistry.GLISTENING_HOOD) && source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.GLISTENING_HELMET) && !source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.GLISTENING_MASK) && source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC)) {
                event.setNewDamage(amount * 0.7f);
            } else if (target.hasEffect(MobEffectRegistry.DEMONIZED_HOOD) && source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.DEMONIZED_HELMET) && !source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.DEMONIZED_MASK) && source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC)) {
                event.setNewDamage(amount * 0.625f);
            } else if (target.hasEffect(MobEffectRegistry.TORMENTED_HOOD) && source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.TORMENTED_HELMET) && !source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC) || target.hasEffect(MobEffectRegistry.TORMENTED_MASK) && source.is(DamageTypes.MOB_PROJECTILE) && !source.is(DamageTypes.MAGIC)) {
                event.setNewDamage(amount * 0.348f);
            } else if (target.hasEffect(MobEffectRegistry.BLOCK_PROTECTION) && (source.is(DamageTypes.CACTUS) || source.is(DamageRegistry.SPIKE.getKey()) || source.is(DamageTypes.FALLING_BLOCK) || source.is(DamageTypes.FALLING_ANVIL) || source.is(DamageTypes.FALLING_STALACTITE) || source.is(DamageTypes.IN_WALL))) {
                event.setNewDamage(0.0f);
            } else if (target.hasEffect(MobEffectRegistry.EXPLOSION_PROTECTION) && (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION))) {
                event.setNewDamage(0.0f);
            } else if (target.hasEffect(MobEffectRegistry.WITHER_PROTECTION) && source.is(DamageTypes.WITHER)) {
                event.setNewDamage(0.0f);
            }
        }
    }
}

