/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import com.mojang.blaze3d.systems.RenderSystem;
import divinerpg.entities.base.EntityDivineBoss;
import divinerpg.entities.boss.EntityAyeraco;
import divinerpg.entities.boss.EntityExperiencedCori;
import divinerpg.entities.boss.EntityKitra;
import divinerpg.entities.boss.EntityTermasect;
import divinerpg.entities.boss.EntityTheWatcher;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;

@OnlyIn(value=Dist.CLIENT)
public class BossBarRenderer {
    private static final String KEY = "boss_bar/";

    @SubscribeEvent
    public void renderGameOverlayEvent(CustomizeGuiOverlayEvent.BossEventProgress event) {
        Minecraft mc = Minecraft.getInstance();
        Component component = event.getBossEvent().getName();
        String name = component.getString();
        List bosses = mc.level.getEntities((Entity)mc.player, mc.player.getBoundingBox().inflate(256.0, 64.0, 256.0), e -> e.getName().getString().equals(name));
        if (bosses != null) {
            for (Entity e2 : bosses) {
                if (!(e2 instanceof EntityDivineBoss) && !(e2 instanceof EntityTheWatcher) && !(e2 instanceof EntityKitra) && !(e2 instanceof EntityTermasect) && !(e2 instanceof EntityExperiencedCori)) continue;
                event.setCanceled(true);
                ResourceLocation[] bossTextures = this.getBossTextures(e2);
                this.drawBar(event, bossTextures[0], bossTextures[1]);
                event.getGuiGraphics().drawString(mc.font, component, (event.getGuiGraphics().guiWidth() >> 1) - (mc.font.width((FormattedText)component) >> 1), event.getY() - 4, 0xFFFFFF);
                return;
            }
        }
    }

    private ResourceLocation[] getBossTextures(Entity boss) {
        String registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)boss.getType()).getPath();
        if (boss instanceof EntityAyeraco) {
            EntityAyeraco a = (EntityAyeraco)boss;
            registryName = this.getAyeracoColor(a.getVariant());
        }
        return new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)(KEY + registryName)), ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)(KEY + registryName + "_background"))};
    }

    private String getAyeracoColor(byte variant) {
        return switch (variant) {
            case 6 -> "blue_ayeraco";
            case 1 -> "green_ayeraco";
            case 2 -> "pink_ayeraco";
            case 3 -> "purple_ayeraco";
            case 4 -> "red_ayeraco";
            case 5 -> "yellow_ayeraco";
            default -> "white_ayeraco";
        };
    }

    private void drawBar(CustomizeGuiOverlayEvent.BossEventProgress event, ResourceLocation texture, ResourceLocation background) {
        this.drawBar(event, 1.0f, background);
        float progress = event.getBossEvent().getProgress();
        if (progress > 0.0f) {
            this.drawBar(event, progress, texture);
        }
    }

    private void drawBar(CustomizeGuiOverlayEvent.BossEventProgress event, float progress, ResourceLocation texture) {
        RenderSystem.enableBlend();
        event.getGuiGraphics().blitSprite(texture, 182, 20, 0, 0, event.getX(), event.getY() - 11, Mth.lerpDiscrete((float)progress, (int)0, (int)182), 20);
        RenderSystem.disableBlend();
    }
}

