/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import divinerpg.client.particle.ParticleColored;
import divinerpg.client.particle.ParticleEnderTriplet;
import divinerpg.client.particle.ParticleFrost;
import divinerpg.client.particle.ParticlePortal;
import divinerpg.client.particle.ParticleSparkler;
import divinerpg.client.particle.ParticleSplash;
import divinerpg.client.particle.ParticleTar;
import divinerpg.client.particle.RiftParticle;
import divinerpg.effect.dimension.IceikaSky;
import divinerpg.effect.dimension.TwilightSky;
import divinerpg.effect.dimension.VetheaSky;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.FluidRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.SelectMusicEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@EventBusSubscriber(modid="divinerpg", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSidedExtraEvents {
    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"block/liquid_tar_still");
            private static final ResourceLocation FLOW = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"block/liquid_tar_flow");

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOW;
            }

            public int getTintColor() {
                return -8388652;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                int color = -15722218;
                return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                LivingEntity entity = (LivingEntity)camera.getEntity();
                if (entity.isSpectator()) {
                    nearDistance = -8.0f;
                    farDistance = renderDistance * 0.25f;
                } else if (entity.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                    nearDistance = 0.0f;
                    farDistance = 4.0f;
                } else {
                    nearDistance = 0.25f;
                    farDistance = 1.0f;
                }
                if (farDistance > renderDistance) {
                    farDistance = renderDistance;
                    shape = FogShape.CYLINDER;
                }
                RenderSystem.setShaderFogStart((float)nearDistance);
                RenderSystem.setShaderFogEnd((float)farDistance);
                RenderSystem.setShaderFogShape((FogShape)shape);
            }
        }, new Holder[]{FluidRegistry.SMOLDERING_TAR});
    }

    @SubscribeEvent
    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"iceika_sky"), (DimensionSpecialEffects)new IceikaSky());
        event.register(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"twilight_sky"), (DimensionSpecialEffects)new TwilightSky());
        event.register(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"vethea_sky"), (DimensionSpecialEffects)new VetheaSky());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.EDEN_PORTAL.get(), ParticlePortal.EdenProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.WILDWOOD_PORTAL.get(), ParticlePortal.WildwoodProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.APALACHIA_PORTAL.get(), ParticlePortal.ApalachiaProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SKYTHERN_PORTAL.get(), ParticlePortal.SkythernProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.MORTUM_PORTAL.get(), ParticlePortal.MortumProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.HALITE_PORTAL.get(), ParticlePortal.HaliteProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.TWILIGHT_PORTAL.get(), ParticlePortal.TwilightProvider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.BLACK_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.BLUE_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.GREEN_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.PURPLE_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.FROST.get(), ParticleFrost.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SPARKLER.get(), ParticleSparkler.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.ENDER_TRIPLET.get(), ParticleEnderTriplet.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.TAR.get(), ParticleTar.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.SPLASH.get(), ParticleSplash.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleRegistry.COLORED.get(), ParticleColored.Provider::new);
        event.registerSprite((ParticleType)ParticleRegistry.EDEN_RIFT.get(), RiftParticle::createParticle);
        event.registerSprite((ParticleType)ParticleRegistry.WILDWOOD_RIFT.get(), RiftParticle::createParticle);
        event.registerSprite((ParticleType)ParticleRegistry.APALACHIA_RIFT.get(), RiftParticle::createParticle);
        event.registerSprite((ParticleType)ParticleRegistry.SKYTHERN_RIFT.get(), RiftParticle::createParticle);
        event.registerSprite((ParticleType)ParticleRegistry.MORTUM_RIFT.get(), RiftParticle::createParticle);
    }

    public static class MusicEvent {
        public static volatile boolean wantsToPlaySnowflakes = false;

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void musicEvent(SelectMusicEvent e) {
            ClientLevel level;
            if (e.getPlayingMusic() == null && (level = Minecraft.getInstance().level) != null && level.dimension() == LevelRegistry.ICEIKA) {
                if (((Boolean)AttachmentRegistry.IN_DUNGEON.get((Entity)Minecraft.getInstance().player)).booleanValue()) {
                    e.setMusic(SoundRegistry.CRYSTAL_TEARS_MUSIC);
                } else if (wantsToPlaySnowflakes) {
                    e.setMusic(SoundRegistry.SNOWFLAKES_MUSIC);
                    wantsToPlaySnowflakes = false;
                }
            }
        }
    }
}

