/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.DivineRPG;
import divinerpg.attachments.Arcana;
import divinerpg.config.ClientConfig;
import divinerpg.network.payload.Weather;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.util.LocalizeUtils;
import divinerpg.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class EventClientLogin {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                DivineRPG.LOGGER.info("Sending weather and arcana info to player");
                PacketDistributor.sendToPlayer((ServerPlayer)pl, (CustomPacketPayload)new Weather(Utils.ICEIKA_WEATHER), (CustomPacketPayload[])new CustomPacketPayload[0]);
                AttachmentRegistry.MAX_ARCANA.set((Entity)pl, Float.valueOf(Arcana.getMaxArcana((LivingEntity)pl)));
                AttachmentRegistry.ARCANA.set((Entity)pl, Float.valueOf(Arcana.getAmount((LivingEntity)pl)));
                AttachmentRegistry.HOOKED.set((Entity)pl, false);
            }
            if (ClientConfig.Values.WELCOME_MESSAGE) {
                if (Utils.isDeveloperName(player.getUUID())) {
                    message = LocalizeUtils.clientMessage(ChatFormatting.DARK_RED, "player.developer", player.getDisplayName());
                    player.sendSystemMessage(message);
                } else if (Utils.isTesterName(player.getUUID())) {
                    message = LocalizeUtils.clientMessage(ChatFormatting.BLUE, "player.tester", player.getDisplayName());
                    player.sendSystemMessage(message);
                } else if (Utils.isSpecial(player.getUUID())) {
                    message = LocalizeUtils.clientMessage(ChatFormatting.GOLD, "player.special", player.getDisplayName());
                    player.sendSystemMessage(message);
                } else if (Utils.isFriend(player.getUUID())) {
                    message = LocalizeUtils.clientMessage(ChatFormatting.LIGHT_PURPLE, "player.friend", player.getDisplayName());
                    player.sendSystemMessage(message);
                }
            }
        }
    }
}

