/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.attachments.Arcana;
import divinerpg.enums.ToolStats;
import divinerpg.items.base.ItemModSword;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ToolAbilities {
    @SubscribeEvent
    public void onLivingHurtEvent(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        float amount = event.getNewDamage();
        Entity entity = event.getSource().getEntity();
        DamageSource source = event.getSource();
        if (entity instanceof Player) {
            ItemStack item;
            Item item2;
            Player attacker = (Player)entity;
            if (source.is(DamageTypes.PLAYER_ATTACK) && (item2 = (item = attacker.getItemInHand(InteractionHand.MAIN_HAND)).getItem()) instanceof ItemModSword) {
                ItemModSword sword = (ItemModSword)item2;
                ToolStats s = sword.sword;
                switch (s.getSwordSpecial()) {
                    case SLOW: {
                        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, s.effectSec * 20, s.effectPower));
                        break;
                    }
                    case POISON: {
                        target.addEffect(new MobEffectInstance(MobEffects.POISON, s.effectSec * 20, s.effectPower));
                        break;
                    }
                    case FLAME: {
                        target.igniteForSeconds((float)s.effectSec);
                    }
                }
                if (sword.arcanaConsumedAttack != 0 && Arcana.hasArcana((LivingEntity)attacker) && Arcana.getAmount((LivingEntity)attacker) >= (float)sword.arcanaConsumedAttack) {
                    Arcana.modifyAmount((LivingEntity)attacker, -sword.arcanaConsumedAttack);
                    if (s.getSwordSpecial() == ToolStats.SwordSpecial.ARCANA_DAMAGE) {
                        event.setNewDamage(amount + CombatRules.getDamageAfterAbsorb((LivingEntity)target, (float)s.effectPower, (DamageSource)source, (float)target.getArmorValue(), (float)((float)target.getAttributeValue(Attributes.ARMOR_TOUGHNESS))));
                    }
                    sword.arcanicAttack(item, attacker, (Entity)target);
                }
            }
        }
    }
}

