/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.config.ClientConfig;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@OnlyIn(value=Dist.CLIENT)
public class Tooltips {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (item instanceof DiggerItem) {
            DiggerItem item2 = (DiggerItem)item;
            if (ClientConfig.Values.TOOL_TOOLTIPIFICATION) {
                tooltip.add(1, LocalizeUtils.efficiency((int)item2.getTier().getSpeed()));
                TagKey tagKey = item2.getTier().getIncorrectBlocksForDrops();
                HolderSet.Named holderSet = BuiltInRegistries.BLOCK.getOrCreateTag(tagKey);
                if (holderSet.stream().anyMatch(holder -> holder.is(BlockTags.NEEDS_STONE_TOOL))) {
                    tooltip.add(2, LocalizeUtils.harvestLevel((Component)Component.literal((String)Items.COAL.getName(stack).getString()).withStyle(ChatFormatting.DARK_GRAY)));
                } else if (holderSet.stream().anyMatch(holder -> holder.is(BlockTags.NEEDS_IRON_TOOL))) {
                    tooltip.add(2, LocalizeUtils.harvestLevel((Component)Component.literal((String)Items.LAPIS_LAZULI.getName(stack).getString()).withColor(5931746)));
                } else if (holderSet.stream().anyMatch(holder -> holder.is(BlockTags.NEEDS_DIAMOND_TOOL))) {
                    tooltip.add(2, LocalizeUtils.harvestLevel((Component)Component.literal((String)Items.DIAMOND.getName(stack).getString()).withColor(2293477)));
                } else if (holderSet.stream().anyMatch(holder -> holder.is(Tags.Blocks.NEEDS_NETHERITE_TOOL))) {
                    tooltip.add(2, LocalizeUtils.harvestLevel((Component)Component.literal((String)Items.OBSIDIAN.getName(stack).getString()).withColor(7096985)));
                } else {
                    tooltip.add(2, LocalizeUtils.harvestLevel((Component)Component.literal((String)(Items.OBSIDIAN.getName(stack).getString() + "+")).withStyle(ChatFormatting.DARK_RED)));
                }
            }
        }
        if (stack.getDescriptionId().contains("torridite")) {
            tooltip.add(1, LocalizeUtils.i18n("torridite", ChatFormatting.DARK_RED, ChatFormatting.BOLD));
        }
    }
}

