/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events.enchant;

import divinerpg.blocks.base.BlockModMobCage;
import divinerpg.events.Ticker;
import divinerpg.registries.EnchantmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class RiveHandler {
    @SubscribeEvent
    public void handleWorldBreak(BlockEvent.BreakEvent event) {
        Direction facing;
        Level world = (Level)event.getLevel();
        Player player = event.getPlayer();
        ItemStack itemStack = player.getMainHandItem();
        BlockState blockState = world.getBlockState(event.getPos());
        int level = EnchantmentHelper.getEnchantmentLevel((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(EnchantmentRegistry.RIVE), (LivingEntity)player);
        float pitch = player.getXRot();
        Direction direction = pitch > 45.0f ? Direction.DOWN : (facing = pitch < -45.0f ? Direction.UP : player.getDirection());
        if (world.isClientSide) {
            return;
        }
        if (player.isShiftKeyDown()) {
            return;
        }
        if (!(itemStack.getItem() instanceof DiggerItem)) {
            return;
        }
        if (!itemStack.getItem().isCorrectToolForDrops(itemStack, blockState)) {
            return;
        }
        if (level < 1) {
            return;
        }
        float destroySpeed = blockState.getDestroySpeed((BlockGetter)world, event.getPos());
        int[] dimensions = this.getSizeByDirection(facing, level);
        int totalBlocksBroken = 0;
        for (int x = dimensions[0]; x <= dimensions[3]; ++x) {
            for (int y = dimensions[1]; y <= dimensions[4]; ++y) {
                for (int z = dimensions[2]; z <= dimensions[5]; ++z) {
                    BlockPos pos = event.getPos().offset(x, y, z);
                    if (!this.tryToBreakBlock(world, player, pos, world.getBlockState(pos), itemStack, destroySpeed)) continue;
                    ++totalBlocksBroken;
                    event.setCanceled(true);
                }
            }
        }
        if (totalBlocksBroken > 0) {
            itemStack.hurtAndBreak(totalBlocksBroken, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }

    private boolean tryToBreakBlock(Level world, Player player, BlockPos pos, BlockState blockState, ItemStack tool, float destroySpeed) {
        Block block = blockState.getBlock();
        if (!tool.getItem().isCorrectToolForDrops(tool, blockState)) {
            return false;
        }
        if (!(block instanceof BlockModMobCage) && blockState.hasBlockEntity()) {
            return false;
        }
        if (block.defaultDestroyTime() < 0.0f || blockState.getDestroySpeed((BlockGetter)world, pos) > destroySpeed) {
            return false;
        }
        if (block.canHarvestBlock(blockState, (BlockGetter)world, pos, player) && world instanceof ServerLevel) {
            FluidState fluidState = world.getFluidState(pos);
            BlockEntity entity = blockState.hasBlockEntity() ? world.getBlockEntity(pos) : null;
            world.destroyBlock(pos, false, (Entity)player);
            if (Ticker.handleTerranShifter((LevelAccessor)world, player, pos, blockState, tool)) {
                return false;
            }
            if (!player.isCreative()) {
                block.playerDestroy(world, player, pos, blockState, entity, tool);
            }
            block.onDestroyedByPlayer(blockState, world, pos, player, true, fluidState);
            return true;
        }
        return false;
    }

    private int[] getSizeByDirection(Direction facing, int level) {
        int[] nArray;
        int depth = level - 1;
        switch (facing) {
            default: {
                throw new MatchException(null, null);
            }
            case NORTH: {
                int[] nArray2 = new int[6];
                nArray2[0] = -1;
                nArray2[1] = -1;
                nArray2[2] = -depth;
                nArray2[3] = 1;
                nArray2[4] = 1;
                nArray = nArray2;
                nArray2[5] = 0;
                break;
            }
            case EAST: {
                int[] nArray3 = new int[6];
                nArray3[0] = 0;
                nArray3[1] = -1;
                nArray3[2] = -1;
                nArray3[3] = depth;
                nArray3[4] = 1;
                nArray = nArray3;
                nArray3[5] = 1;
                break;
            }
            case WEST: {
                int[] nArray4 = new int[6];
                nArray4[0] = -depth;
                nArray4[1] = -1;
                nArray4[2] = -1;
                nArray4[3] = 0;
                nArray4[4] = 1;
                nArray = nArray4;
                nArray4[5] = 1;
                break;
            }
            case SOUTH: {
                int[] nArray5 = new int[6];
                nArray5[0] = -1;
                nArray5[1] = -1;
                nArray5[2] = 0;
                nArray5[3] = 1;
                nArray5[4] = 1;
                nArray = nArray5;
                nArray5[5] = depth;
                break;
            }
            case UP: {
                int[] nArray6 = new int[6];
                nArray6[0] = -1;
                nArray6[1] = 0;
                nArray6[2] = -1;
                nArray6[3] = 1;
                nArray6[4] = depth;
                nArray = nArray6;
                nArray6[5] = 1;
                break;
            }
            case DOWN: {
                int[] nArray7 = new int[6];
                nArray7[0] = -1;
                nArray7[1] = -depth;
                nArray7[2] = -1;
                nArray7[3] = 1;
                nArray7[4] = 0;
                nArray = nArray7;
                nArray7[5] = 1;
            }
        }
        return nArray;
    }
}

