/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemAquamarine
extends BucketItem {
    public ItemAquamarine() {
        super((Fluid)Fluids.WATER, new Item.Properties().durability(3));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = ItemAquamarine.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockhitresult.getType() == HitResult.Type.MISS || blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos = blockhitresult.getBlockPos();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            BlockState blockstate = level.getBlockState(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, level, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.emptyContents(player, level, blockpos2, blockhitresult, itemstack)) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos2, itemstack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                if (!player.isCreative()) {
                    itemstack.setDamageValue(itemstack.getDamageValue() + 1);
                    if (itemstack.getDamageValue() >= itemstack.getMaxDamage()) {
                        return InteractionResultHolder.sidedSuccess((Object)ItemStack.EMPTY, (boolean)level.isClientSide);
                    }
                }
                return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide);
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

