/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.attachments.Arcana;
import divinerpg.items.base.ItemModFood;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemArcanaPotion
extends ItemModFood {
    protected int amountToAdd;

    public ItemArcanaPotion(FoodProperties food, int amountToAdd) {
        super(false, Items.GLASS_BOTTLE, food);
        this.amountToAdd = amountToAdd;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        ServerPlayer player;
        if (entityLiving instanceof ServerPlayer) {
            player = (ServerPlayer)entityLiving;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
        }
        if (!level.isClientSide) {
            if (Arcana.hasArcana(entityLiving)) {
                Arcana.modifyAmount(entityLiving, this.amountToAdd);
            }
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            if (entityLiving instanceof Player && !(player = (Player)entityLiving).hasInfiniteMaterials()) {
                ItemStack itemstack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!player.getInventory().add(itemstack)) {
                    player.drop(itemstack, false);
                }
            }
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.arcanaRegen(this.amountToAdd));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

