/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemDivineAccumulator
extends ItemMod {
    public ItemDivineAccumulator() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
        this.arcanaConsumedUse = 80;
        this.cooldown = 10;
    }

    @Override
    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        for (double r = 0.0; r < 4.0; r += 0.1) {
            for (double theta = 0.0; theta < Math.PI * 2; theta += 0.1308996938995747) {
                level.addParticle((ParticleOptions)ParticleRegistry.EDEN_PORTAL.get(), x + r * Math.cos(theta), y, z + r * Math.sin(theta), Math.random(), Math.random(), Math.random());
            }
        }
        player.setJumping(false);
        player.setOnGround(false);
        player.setDeltaMovement(player.getDeltaMovement().x, player.getDeltaMovement().y + 2.0, player.getDeltaMovement().z);
        player.playSound((SoundEvent)SoundRegistry.DIVINE_ACCUMULATOR.get(), 1.0f, 1.0f);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("divine_accumulator.launch"));
        tooltip.add(LocalizeUtils.i18n("divine_accumulator.fall"));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

