/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.items.base.ItemMod;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemEnderScepter
extends ItemMod {
    public ItemEnderScepter() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
        this.arcanaConsumedUse = 75;
        this.cooldown = 10;
    }

    @Override
    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        int i;
        int blockReachDistance = 40;
        Vec3 vec3d = player.getEyePosition(1.0f);
        Vec3 vec3d1 = player.getViewVector(1.0f);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * (double)blockReachDistance, vec3d1.y * (double)blockReachDistance, vec3d1.z * (double)blockReachDistance);
        BlockHitResult pos = player.level().clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        player.resetFallDistance();
        if (player.isPassenger()) {
            player.stopRiding();
        }
        for (i = 0; i < 5; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX() + player.getRandom().nextDouble() - 0.5, player.getY(), player.getZ() + player.getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        player.moveTo(pos.getLocation());
        for (i = 0; i < 5; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, player.getX() + player.getRandom().nextDouble() - 0.5, player.getY(), player.getZ() + player.getRandom().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        player.playSound(SoundEvents.CHORUS_FRUIT_TELEPORT, 1.0f, 1.0f);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("ender_scepter"));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

