/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemFireStock
extends ItemMod {
    public void onDestroyed(ItemEntity item, DamageSource damageSource) {
        Level level = item.level();
        BlockState state = item.getInBlockState();
        if ((damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.ON_FIRE)) && state.is(BlockTags.FIRE)) {
            RandomSource random = item.getRandom();
            for (int i = 0; i < item.getItem().getCount(); ++i) {
                BlockPos pos = item.blockPosition().offset(random.nextInt(3) - 1, random.nextInt(2) - 1, random.nextInt(3) - 1);
                if (!level.getBlockState(pos).isAir() || !level.getBlockState(pos = pos.below()).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) continue;
                level.playSound(null, pos, SoundEvents.FIRECHARGE_USE, SoundSource.BLOCKS, 0.6f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                level.setBlock(pos.above(), state, 3);
            }
            if (!state.is(TagRegistry.FIRE_BLOCK)) {
                level.playSound(null, item.getX(), item.getY(), item.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.6f, 1.3f);
            }
        }
    }
}

