/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.attachments.Arcana;
import divinerpg.entities.arcana.EntityWraith;
import divinerpg.enums.EntityStats;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemGhostbane
extends ItemMod {
    public ItemGhostbane() {
        super(new Item.Properties().stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
        this.arcanaConsumedUse = 200;
        this.cooldown = 60;
    }

    @Override
    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ((EntityWraith)((EntityType)EntityRegistry.WRAITH.get()).spawn((ServerLevel)level, ItemStack.EMPTY, player, player.blockPosition(), MobSpawnType.MOB_SUMMONED, true, false)).tame(player);
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            float amount = Arcana.getAmount((LivingEntity)pl);
            if (this.arcanaConsumedUse != 0 && amount >= (float)this.arcanaConsumedUse) {
                Arcana.modifyAmount((LivingEntity)pl, -this.arcanaConsumedUse);
                pl.getCooldowns().addCooldown((Item)this, this.cooldown);
                BlockPos pos = context.getClickedPos();
                if (!context.getLevel().getBlockState(pos).getCollisionShape((BlockGetter)context.getLevel(), pos).isEmpty()) {
                    pos = pos.relative(context.getClickedFace());
                }
                ((EntityWraith)((EntityType)EntityRegistry.WRAITH.get()).spawn((ServerLevel)context.getLevel(), ItemStack.EMPTY, (Player)pl, pos, MobSpawnType.MOB_SUMMONED, true, false)).tame((Player)pl);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.summoned((EntityType)EntityRegistry.WRAITH.get()));
        tooltip.add(LocalizeUtils.summonedDamage((int)EntityStats.WRAITH.getAttackDamage()));
        tooltip.add(LocalizeUtils.summonedHealth((int)EntityStats.WRAITH.getHealth()));
        tooltip.add(LocalizeUtils.summonedDespawn());
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

