/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.arcana;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStaffEnrichment
extends ItemMod {
    public ItemStaffEnrichment() {
        super(new Item.Properties().durability(100));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Block block = level.getBlockState(pos).getBlock();
        if (block == BlockRegistry.arcaniteDirt.get()) {
            level.levelEvent(1505, pos, 0);
            level.setBlock(pos, ((Block)BlockRegistry.arcaniteGrass.get()).defaultBlockState(), 0);
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("staff_of_enrichment"));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

