/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.registries.ItemRegistry;
import divinerpg.util.ArmorInfo;
import divinerpg.util.IFullSetInfo;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemDivineArmor
extends ArmorItem
implements IFullSetInfo {
    public ArmorInfo armorInfo;
    public final Holder<MobEffect>[] supportedEffects;
    public final int[] amplifier;
    public Integer nameColor;

    public ItemDivineArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : new Item.Properties().durability(slot.getDurability(durability)));
        this.supportedEffects = null;
        this.amplifier = null;
    }

    public ItemDivineArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : new Item.Properties().durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = null;
        this.amplifier = null;
    }

    public ItemDivineArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo, Item.Properties properties) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : properties.durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = null;
        this.amplifier = null;
    }

    @SafeVarargs
    public ItemDivineArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo, Item.Properties properties, Holder<MobEffect> ... effects) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : properties.durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = null;
    }

    @SafeVarargs
    public ItemDivineArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo, Holder<MobEffect> ... effects) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : new Item.Properties().durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = null;
    }

    @SafeVarargs
    public ItemDivineArmor(int rarity, Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo, Holder<MobEffect> ... effects) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : new Item.Properties().durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = null;
        this.nameColor = rarity;
    }

    @SafeVarargs
    public ItemDivineArmor(Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo, int[] amplifier, Holder<MobEffect> ... effects) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : new Item.Properties().durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = amplifier;
    }

    @SafeVarargs
    public ItemDivineArmor(int rarity, Holder<ArmorMaterial> materialIn, ArmorItem.Type slot, int durability, ArmorInfo armorInfo, int[] amplifier, Holder<MobEffect> ... effects) {
        super(materialIn, slot, slot.getDurability(durability) == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).stacksTo(1) : new Item.Properties().durability(slot.getDurability(durability)));
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = amplifier;
        this.nameColor = rarity;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.getItem() == ItemRegistry.seng_fur_boots.get() || stack.getItem() == ItemRegistry.santa_boots.get();
    }

    @Override
    public Component getFullSetPerks() {
        if (this.armorInfo == null) {
            return null;
        }
        return this.armorInfo.FullSetPerks;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.armorInfo != null) {
            tooltip.addAll(this.armorInfo.asString());
        }
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }
}

