/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.client.renders.item.DivineShieldRenderer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class ItemDivineShield
extends ShieldItem {
    public ResourceLocation resource;
    public Integer nameColor;
    private final Ingredient repairMaterial;

    public ItemDivineShield(int nameColor, TagKey<Item> repairMaterial, int durability, String name) {
        super(durability == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties().durability(durability));
        this.repairMaterial = repairMaterial == null ? Ingredient.EMPTY : Ingredient.of(repairMaterial);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
        this.resource = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("entity/shield/" + name + "_shield"));
        this.nameColor = nameColor;
    }

    public ItemDivineShield(TagKey<Item> repairMaterial, int durability, String name) {
        super(durability == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties().durability(durability));
        this.repairMaterial = repairMaterial == null ? Ingredient.EMPTY : Ingredient.of(repairMaterial);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
        this.resource = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("entity/shield/" + name + "_shield"));
    }

    public boolean isValidRepairItem(ItemStack shield, ItemStack repairItem) {
        return this.repairMaterial.test(repairItem);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderProps.INSTANCE);
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }

    static class RenderProps
    implements IClientItemExtensions {
        public static RenderProps INSTANCE = new RenderProps();

        RenderProps() {
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return new DivineShieldRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        }
    }
}

