/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemModFood;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemHealingFood
extends ItemModFood {
    protected int healAmount;

    public ItemHealingFood(FoodProperties food) {
        super(food);
        this.healAmount = food.nutrition() * 2;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entity) {
        if (entity.getHealth() < entity.getMaxHealth()) {
            entity.heal((float)this.healAmount);
        }
        return super.finishUsingItem(stack, world, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.healthHeal(this.healAmount / 2));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

