/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemModSword;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemHealingSword
extends ItemModSword {
    public float healAmount;

    public ItemHealingSword(Tier material, float heals) {
        super(material);
        this.healAmount = heals;
        this.cooldown = 3;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.getHealth() < attacker.getMaxHealth()) {
            attacker.heal(this.healAmount);
            attacker.level().playSound(null, attacker.blockPosition(), (SoundEvent)SoundRegistry.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.getHealth() < player.getMaxHealth()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            player.heal(this.healAmount);
            if (player.isOnFire() && this == ItemRegistry.frossivence.get()) {
                player.clearFire();
            }
            player.playSound((SoundEvent)SoundRegistry.HEAL.get(), 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        NeutralMob mob;
        if (!(entity instanceof ServerPlayer || entity instanceof Monster || entity instanceof NeutralMob && (mob = (NeutralMob)entity).isAngry() || !(entity.getHealth() < entity.getMaxHealth()) || player.getCooldowns().isOnCooldown((Item)this))) {
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            entity.heal(this.healAmount);
            if (entity.isOnFire() && this == ItemRegistry.frossivence.get()) {
                entity.extinguishFire();
            }
            entity.playSound((SoundEvent)SoundRegistry.HEAL.get(), 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                double d0 = entity.getRandom().nextGaussian() * 0.02;
                double d1 = entity.getRandom().nextGaussian() * 0.02;
                double d2 = entity.getRandom().nextGaussian() * 0.02;
                entity.level().addParticle((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, entity, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.healthHeal(Float.valueOf(this.healAmount / 2.0f)));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

