/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemModSword;
import divinerpg.recipe.MaulSmashingRecipe;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemMaul
extends ItemModSword {
    private static final int COOLDOWN_TICKS = 10;

    public ItemMaul(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public ItemMaul(Tier tier) {
        super(tier);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Vec3 lookVec;
        if (level.isClientSide) {
            return super.use(level, player, hand);
        }
        double range = player.entityInteractionRange();
        Vec3 eyePos = player.getEyePosition();
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePos, (Vec3)eyePos.add((lookVec = player.getViewVector(1.0f)).scale(range)), (AABB)player.getBoundingBox().expandTowards(lookVec.scale(range)).inflate(1.0), e -> e instanceof ItemEntity, (double)(range * range));
        if (hitResult != null) {
            ItemEntity itemEntity = (ItemEntity)hitResult.getEntity();
            ItemStack targetStack = itemEntity.getItem();
            MaulSmashingRecipe matchingRecipe = this.findMatchingRecipe(level.getRecipeManager(), targetStack, level, itemEntity.blockPosition());
            if (matchingRecipe != null) {
                ItemStack resultStack = matchingRecipe.getResult();
                ItemStack maulStack = player.getItemInHand(hand);
                int itemsToSmashCount = maulStack.has(DataComponents.UNBREAKABLE) ? targetStack.getCount() : Math.min(targetStack.getCount(), maulStack.getMaxDamage() - maulStack.getDamageValue());
                resultStack.setCount(resultStack.getCount() * itemsToSmashCount);
                targetStack.shrink(itemsToSmashCount);
                ItemEntity convertedEntity = new ItemEntity(level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), resultStack);
                level.addFreshEntity((Entity)convertedEntity);
                convertedEntity.setItem(resultStack);
                this.applyMaulEffects(player, itemsToSmashCount, hand);
                return InteractionResultHolder.success((Object)player.getItemInHand(hand));
            }
        }
        return super.use(level, player, hand);
    }

    private void applyMaulEffects(Player player, int count, InteractionHand hand) {
        ItemStack maulStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)player;
            maulStack.hurtAndBreak(count, s.serverLevel(), s, it -> s.serverLevel().playSound(null, player.getX(), player.getEyeY(), player.getZ(), SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f));
        }
        player.level().playSound(null, player.getX(), player.getEyeY(), player.getZ(), SoundEvents.ANVIL_LAND, SoundSource.PLAYERS, 0.7f, 1.5f);
        player.getCooldowns().addCooldown((Item)this, 10);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
    }

    @Nullable
    private MaulSmashingRecipe findMatchingRecipe(RecipeManager recipeManager, ItemStack inputStack, Level level, BlockPos itemPos) {
        BlockState baseState = level.getBlockState(itemPos.below());
        for (RecipeHolder holder : recipeManager.getAllRecipesFor(MaulSmashingRecipe.TYPE)) {
            Optional tagBlocksOpt;
            Optional blockLookup;
            MaulSmashingRecipe recipe;
            Recipe recipe2 = holder.value();
            if (!(recipe2 instanceof MaulSmashingRecipe) || !(recipe = (MaulSmashingRecipe)recipe2).matches(inputStack)) continue;
            TagKey<Block> tag = recipe.requiredBaseBlockTag();
            if (tag == null) {
                return recipe;
            }
            MinecraftServer server = level.getServer();
            if (server == null || (blockLookup = server.registryAccess().lookup(Registries.BLOCK)).isEmpty() || (tagBlocksOpt = ((HolderLookup.RegistryLookup)blockLookup.get()).get(tag)).isEmpty() || !baseState.is((HolderSet)tagBlocksOpt.get())) continue;
            return recipe;
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocalizeUtils.i18n("tool.maul_use"));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

