/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.attachments.Arcana;
import divinerpg.items.vethea.ItemMinersAmulet;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemMod
extends Item {
    public Integer nameColor;
    public int arcanaConsumedUse;
    public int cooldown;

    public ItemMod() {
        super(new Item.Properties());
    }

    public ItemMod(Item.Properties properties) {
        super(properties);
    }

    public ItemMod setArcanaUseConsumption(int amount) {
        this.arcanaConsumedUse = amount;
        return this;
    }

    public ItemMod setArcanaUseCooldown(int amount) {
        this.cooldown = amount;
        return this;
    }

    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.arcanaConsumedUse != 0 && Arcana.getAmount((LivingEntity)player) >= (float)this.arcanaConsumedUse) {
            if (!level.isClientSide()) {
                Arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
            }
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return this.arcanicUse(level, player, hand);
        }
        return super.use(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potioncontents != null) {
            if (!(this instanceof ItemMinersAmulet)) {
                tooltip.add(LocalizeUtils.inflict());
            }
            potioncontents.addPotionTooltip(tooltip::add, 1.0f, context.tickRate());
        }
        if (this.arcanaConsumedUse > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedUse));
        }
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }
}

