/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.items.base.ItemMod;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemModFood
extends ItemMod {
    protected boolean fastFood;

    public ItemModFood(Item.Properties properties, FoodProperties food) {
        super(properties.food(food));
    }

    public ItemModFood(FoodProperties food) {
        this(new Item.Properties(), food);
    }

    public ItemModFood(boolean stacksToOne, FoodProperties food) {
        this(new Item.Properties().stacksTo(stacksToOne ? 1 : 16), food);
    }

    public ItemModFood(boolean stacksToOne, Item craftRemainder, FoodProperties food) {
        this(new Item.Properties().craftRemainder(craftRemainder).stacksTo(stacksToOne ? 1 : 16), food);
    }

    public ItemModFood(FoodProperties food, boolean instantConsumption) {
        this(new Item.Properties(), food);
        this.fastFood = instantConsumption;
    }

    public ItemModFood(boolean stacksToOne, FoodProperties food, boolean instantConsumption) {
        this(new Item.Properties().stacksTo(stacksToOne ? 1 : 16), food);
        this.fastFood = instantConsumption;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.fastFood ? 1 : super.getUseDuration(stack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.fastFood) {
            tooltip.add(LocalizeUtils.instantConsumption());
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

