/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.compat.farmersdelight.DelightLoader;
import divinerpg.items.base.ItemModFood;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

public class ItemModFoodEffect
extends ItemModFood {
    private final FoodProperties food;

    public ItemModFoodEffect(FoodProperties food) {
        super(food);
        this.food = food;
    }

    public ItemModFoodEffect(boolean stacksToOne, FoodProperties food) {
        super(stacksToOne, food);
        this.food = food;
    }

    public ItemModFoodEffect(boolean stacksToOne, Item craftRemainder, FoodProperties food) {
        super(stacksToOne, craftRemainder, food);
        this.food = food;
    }

    public ItemModFoodEffect(FoodProperties food, boolean instantConsumption) {
        super(food, instantConsumption);
        this.food = food;
    }

    public ItemModFoodEffect(boolean stacksToOne, FoodProperties food, boolean instantConsumption) {
        super(stacksToOne, food, instantConsumption);
        this.food = food;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        boolean tooltipAdded = false;
        if (!ModList.get().isLoaded("farmersdelight") || DelightLoader.foodEffectTooltipEnabled()) {
            for (FoodProperties.PossibleEffect effect : this.food.effects()) {
                float chance = effect.probability();
                if (chance < 1.0f && !tooltipAdded) {
                    tooltip.add(LocalizeUtils.i18n(ChatFormatting.GRAY, "chance", (int)(chance * 100.0f)));
                }
                tooltipAdded = true;
            }
            PotionContents.addPotionTooltip(this.food.effects().stream().map(FoodProperties.PossibleEffect::effect).toList(), tooltip::add, (float)1.0f, (float)context.tickRate());
        }
    }
}

