/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.attachments.Arcana;
import divinerpg.enums.ToolStats;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemModSword
extends SwordItem {
    public Integer nameColor;
    public int arcanaConsumedUse;
    public int arcanaConsumedAttack;
    public int cooldown;
    public ToolStats sword;

    public ItemModSword(Tier tier, Item.Properties properties) {
        super(tier, (tier.getUses() == 0 ? properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : properties).attributes(SwordItem.createAttributes((Tier)tier, (int)1, (float)tier.getSpeed())));
        this.sword = (ToolStats)tier;
    }

    public ItemModSword(Tier tier, int rarity) {
        this(tier, new Item.Properties());
        this.sword = (ToolStats)tier;
        this.nameColor = rarity;
    }

    public ItemModSword(Tier tier) {
        super(tier, (tier.getUses() == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties()).attributes(SwordItem.createAttributes((Tier)tier, (int)1, (float)tier.getSpeed())));
        this.sword = (ToolStats)tier;
    }

    public ItemModSword(Tier tier, float speed) {
        super(tier, (tier.getUses() == 0 ? new Item.Properties().component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : new Item.Properties()).attributes(SwordItem.createAttributes((Tier)tier, (int)1, (float)speed)));
        this.sword = (ToolStats)tier;
    }

    public ItemModSword setAttackArcanaConsumption(int amount) {
        this.arcanaConsumedAttack = amount;
        return this;
    }

    public void arcanicAttack(ItemStack stack, Player player, Entity entity) {
    }

    protected InteractionResultHolder<ItemStack> arcanicUse(Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (this.arcanaConsumedUse != 0 && Arcana.getAmount((LivingEntity)player) >= (float)this.arcanaConsumedUse) {
            if (!level.isClientSide()) {
                Arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
            }
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return this.arcanicUse(level, player, hand);
        }
        return super.use(level, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.ARCANA_DAMAGE) {
            tooltip.add(LocalizeUtils.weakenedWithoutArcana());
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.FLAME) {
            tooltip.add(LocalizeUtils.burn(this.sword.effectSec));
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.LIGHTNING) {
            tooltip.add(LocalizeUtils.lightningShots());
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.POISON) {
            tooltip.add(LocalizeUtils.poison(this.sword.effectSec));
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.SLOW) {
            tooltip.add(LocalizeUtils.slow(this.sword.effectSec));
        }
        if (this.sword.getSwordSpecial() == ToolStats.SwordSpecial.SPEED) {
            tooltip.add(LocalizeUtils.i18n("shadow_saber"));
        }
        if (this.arcanaConsumedUse > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedUse));
        }
        if (this.arcanaConsumedAttack > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumedAttack));
        }
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }
}

