/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import divinerpg.registries.TagRegistry;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ItemShickaxe
extends DiggerItem {
    public Integer nameColor;
    private static final Set<ItemAbility> TOOL_ACTIONS = Stream.of(ItemAbilities.AXE_DIG, ItemAbilities.AXE_SCRAPE, ItemAbilities.AXE_STRIP, ItemAbilities.AXE_WAX_OFF, ItemAbilities.PICKAXE_DIG, ItemAbilities.SHOVEL_DIG, ItemAbilities.SHOVEL_FLATTEN, ItemAbilities.HOE_DIG, ItemAbilities.HOE_TILL).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public ItemShickaxe(Tier tier, Item.Properties properties) {
        super(tier, TagRegistry.MINEABLE_WITH_SHICKAXE, (tier.getUses() == 0 ? properties.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)) : properties).attributes(ShovelItem.createAttributes((Tier)tier, (float)1.0f, (float)-2.4f)));
    }

    public ItemShickaxe(Tier tier) {
        this(tier, new Item.Properties());
    }

    public ItemShickaxe(Tier tier, int rarity) {
        this(tier, new Item.Properties());
        this.nameColor = rarity;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return TOOL_ACTIONS.contains(itemAbility);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState state = level.getBlockState(blockpos);
        InteractionHand hand = context.getHand();
        Player player = context.getPlayer();
        BlockState toolModifiedState = state.getToolModifiedState(context, ItemAbilities.HOE_TILL, false);
        Pair pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.changeIntoState((BlockState)toolModifiedState));
        Optional<BlockState> optional = Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(state.getToolModifiedState(context, ItemAbilities.AXE_WAX_OFF, false));
        ItemStack stack = context.getItemInHand();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.playSound(player, blockpos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.playSound(player, blockpos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.playSound(player, blockpos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, stack);
            }
            level.setBlock(blockpos, (BlockState)optional3.get(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)((BlockState)optional3.get())));
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (pair != null && !player.isShiftKeyDown()) {
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                level.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.isClientSide) {
                    consumer.accept(context);
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        BlockState blockstate1 = state.getToolModifiedState(context, ItemAbilities.SHOVEL_FLATTEN, false);
        BlockState blockstate2 = null;
        if (context.getClickedFace() != Direction.DOWN) {
            if (blockstate1 != null && level.isEmptyBlock(blockpos.above()) && player.isShiftKeyDown()) {
                level.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                blockstate2 = blockstate1;
            } else if (state.getBlock() instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                if (!level.isClientSide) {
                    level.levelEvent(null, 1009, blockpos, 0);
                }
                CampfireBlock.dowse((Entity)context.getPlayer(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)state);
                blockstate2 = (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            if (blockstate2 != null) {
                if (!level.isClientSide) {
                    level.setBlock(blockpos, blockstate2, 11);
                    level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)blockstate2));
                    if (player != null) {
                        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack pStack) {
        return this.nameColor != null ? ((MutableComponent)super.getName(pStack)).withColor(this.nameColor.intValue()) : super.getName(pStack);
    }
}

