/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged;

import divinerpg.items.ranged.ItemBow;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemDivineArrow
extends ArrowItem {
    public ItemDivineArrow(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInfinite(ItemStack ammo, ItemStack bow, LivingEntity livingEntity) {
        if (bow.getEnchantmentLevel(livingEntity.registryAccess().holderOrThrow(Enchantments.INFINITY)) > 0) return true;
        Item item = bow.getItem();
        if (!(item instanceof ItemBow)) return false;
        ItemBow b = (ItemBow)item;
        if (b.infinityArrow == null) return false;
        if (b.infinityArrow.get() != this) return false;
        return true;
    }

    public int getBaseDamage() {
        return 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.baseDamage(this.getBaseDamage()));
        PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potioncontents != null) {
            potioncontents.addPotionTooltip(tooltip::add, 1.0f, context.tickRate());
        }
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

