/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.bows;

import divinerpg.enums.ToolStats;
import divinerpg.items.ranged.ItemBow;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.RarityList;
import divinerpg.util.Utils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class InfernoBow
extends ItemBow {
    public InfernoBow() {
        super(ToolStats.INFERNO_BOW, new Item.Properties().fireResistant().component(DataComponentRegistry.weaponAbility, (Object)0).component(DataComponentRegistry.weaponPower, (Object)Float.valueOf(1.0f)), (Supplier<Item>)ItemRegistry.inferno_arrow, RarityList.INFERNO);
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack) {
        arrow.igniteForTicks(0x3FFFFFFF);
        return arrow;
    }

    @Override
    public ItemStack getDefaultCreativeAmmo(@Nullable Player player, ItemStack projectileWeaponItem) {
        return new ItemStack((ItemLike)ItemRegistry.inferno_arrow.get());
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) && !enchantment.is(Enchantments.FLAME);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book) && !Utils.hasStoredEnchantment((ResourceKey<Enchantment>)Enchantments.FLAME, book);
    }

    @Override
    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int timeLeft) {
        int i;
        if (living instanceof Player) {
            Player player = (Player)living;
            ItemStack itemstack = player.getProjectile(stack);
            if (this.infinityArrow != null && (itemstack.isEmpty() || itemstack.is((Item)this.infinityArrow.get()))) {
                itemstack = new ItemStack((ItemLike)this.infinityArrow.get());
            }
            if (itemstack.isEmpty()) {
                return;
            }
            i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)((this.getUseDuration(stack, (LivingEntity)player) - timeLeft) * 72000 / this.useDuration), (boolean)true);
            player.getCooldowns().addCooldown((Item)this, 60);
        } else {
            i = (this.getUseDuration(stack, living) - timeLeft) * 72000 / this.useDuration;
        }
        if (i < 0) {
            return;
        }
        float f = InfernoBow.getPowerForTime((int)i);
        if (f >= 0.1f) {
            stack.set(DataComponentRegistry.weaponAbility, (Object)9);
            stack.set(DataComponentRegistry.weaponPower, (Object)Float.valueOf(f));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected && (level.getGameTime() & 1L) == 0L && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int cooldown = (Integer)stack.get(DataComponentRegistry.weaponAbility);
            if (cooldown > 0) {
                stack.set(DataComponentRegistry.weaponAbility, (Object)(cooldown - 1));
                float f = ((Float)stack.get(DataComponentRegistry.weaponPower)).floatValue();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemStack itemstack = player.getProjectile(stack);
                    if (this.infinityArrow != null && (itemstack.isEmpty() || itemstack.is((Item)this.infinityArrow.get()))) {
                        itemstack = new ItemStack((ItemLike)this.infinityArrow.get());
                    }
                    if (itemstack.isEmpty()) {
                        return;
                    }
                    List list = InfernoBow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                    if (!list.isEmpty()) {
                        this.shoot(server, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f * this.speedScale, 8.0f, f == 1.0f, null);
                    }
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundRegistry.INFERNO_BOW_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                } else if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity;
                    LivingEntity living = (LivingEntity)entity;
                    InteractionHand interactionHand = living.getUsedItemHand();
                    List<ItemStack> list = List.of(new ItemStack((ItemLike)ItemRegistry.inferno_arrow.get()));
                    boolean bl = f == 1.0f;
                    if (living instanceof Mob) {
                        Mob mob = (Mob)living;
                        livingEntity = mob.getTarget();
                    } else {
                        livingEntity = null;
                    }
                    this.shoot(server, living, interactionHand, stack, list, f * 3.0f * this.speedScale, 8.0f, bl, livingEntity);
                    living.playSound((SoundEvent)SoundRegistry.INFERNO_BOW_SHOOT.get(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                }
            }
        }
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (remainingUseDuration == this.useDuration) {
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CAMPFIRE_CRACKLE, entity.getSoundSource(), 1.0f, 1.0f);
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)SoundRegistry.INFERNO_BOW_CHARGE.get(), entity.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

