/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.ranged.shooter;

import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.TagRegistry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemJungleHook
extends ItemRangedWeapon {
    public ItemJungleHook() {
        super(TagRegistry.AMMO_ROPE, () -> ((Item)Items.LEAD).getDefaultInstance(), () -> EntityRegistry.HOOK.value(), 100);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getDamageValue() >= stack.getMaxDamage() - 1) {
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            return InteractionResultHolder.consume((Object)stack);
        }
        if (((Boolean)AttachmentRegistry.HOOKED.get((Entity)player)).booleanValue()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }
}

