/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.twilight;

import divinerpg.blocks.base.PortalBlock;
import divinerpg.items.base.ItemMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.LevelRegistry;
import divinerpg.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemFrozenClock
extends ItemMod {
    public static final ResourceLocation ADVANCEMENT_OOPS = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"divine/oops");

    public ItemFrozenClock() {
        super(new Item.Properties().component(DataComponentRegistry.variant, (Object)0));
    }

    public static InteractionResult useOnPortalBlock(Level level, Player player, BlockPos facing, BlockState block, byte timeOfDay) {
        Direction.Axis axis;
        PortalBlock portal = null;
        ResourceKey dim = level.dimension();
        if (block.is(BlockRegistry.edenBlock) && (timeOfDay == 0 || timeOfDay == 5 && dim == LevelRegistry.EDEN)) {
            portal = (PortalBlock)BlockRegistry.edenPortal.get();
        } else if (block.is(BlockRegistry.wildwoodBlock) && (timeOfDay == 1 || timeOfDay == 0 && dim == LevelRegistry.WILDWOOD)) {
            portal = (PortalBlock)BlockRegistry.wildwoodPortal.get();
        } else if (block.is(BlockRegistry.apalachiaBlock) && (timeOfDay == 2 || timeOfDay == 1 && dim == LevelRegistry.APALACHIA)) {
            portal = (PortalBlock)BlockRegistry.apalachiaPortal.get();
        } else if (block.is(BlockRegistry.skythernBlock) && (timeOfDay == 3 || timeOfDay == 2 && dim == LevelRegistry.SKYTHERN)) {
            portal = (PortalBlock)BlockRegistry.skythernPortal.get();
        } else if (block.is(BlockRegistry.mortumBlock) && (timeOfDay == 4 || timeOfDay == 3 && dim == LevelRegistry.MORTUM)) {
            portal = (PortalBlock)BlockRegistry.mortumPortal.get();
        }
        if (portal != null && (axis = portal.checkForFrame(level, facing)) != null) {
            if (!level.isClientSide) {
                PortalBlock.spreadBlock(level, (BlockState)portal.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis), facing, Blocks.AIR, axis);
            }
            level.playSound(null, facing, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, player.getRandom().nextFloat() * 0.4f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static boolean useOnFire(Level level, Player player, BlockPos pos, BlockState state, byte timeOfDay) {
        switch (timeOfDay) {
            case 0: {
                if (!state.is(BlockRegistry.divineFlame)) break;
                if (level.getBlockState(pos.above()).is(BlockRegistry.edenRift)) {
                    return false;
                }
                level.setBlock(pos.above(), ((Block)BlockRegistry.edenRift.get()).defaultBlockState(), 3);
                return true;
            }
            case 1: {
                if (!state.is(BlockRegistry.wildFlame)) break;
                if (level.getBlockState(pos.above()).is(BlockRegistry.wildwoodRift)) {
                    return false;
                }
                level.setBlock(pos.above(), ((Block)BlockRegistry.wildwoodRift.get()).defaultBlockState(), 3);
                return true;
            }
            case 2: {
                if (!state.is(BlockRegistry.enchantedFlame)) break;
                if (level.getBlockState(pos.above()).is(BlockRegistry.apalachiaRift)) {
                    return false;
                }
                level.setBlock(pos.above(), ((Block)BlockRegistry.apalachiaRift.get()).defaultBlockState(), 3);
                return true;
            }
            case 3: {
                if (!state.is(BlockRegistry.skyFire)) break;
                if (level.getBlockState(pos.above()).is(BlockRegistry.skythernRift)) {
                    return false;
                }
                level.setBlock(pos.above(), ((Block)BlockRegistry.skythernRift.get()).defaultBlockState(), 3);
                return true;
            }
            case 4: {
                if (!state.is(BlockRegistry.mortumEmbers)) break;
                if (level.getBlockState(pos.above()).is(BlockRegistry.mortumRift)) {
                    return false;
                }
                level.setBlock(pos.above(), ((Block)BlockRegistry.mortumRift.get()).defaultBlockState(), 3);
                return true;
            }
        }
        level.explode((Entity)player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, true, Level.ExplosionInteraction.BLOCK);
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            Utils.awardAdvancement(s.getServer(), (ServerPlayer)player, ADVANCEMENT_OOPS, "explode_rift");
        }
        return true;
    }
}

