/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.entities.projectile.magic.DivineMagicProjectile;
import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemScythe
extends ItemRangedWeapon {
    public ItemScythe() {
        super(() -> EntityRegistry.SCYTHE_SHOT.value());
        this.sound = (SoundEvent)SoundRegistry.DEEP_LAUGH.get();
        this.cooldown = 10;
        this.infinite = true;
    }

    private boolean isJackoman(Player player) {
        return ((ItemStack)player.getInventory().armor.get(0)).is((Item)ItemRegistry.jack_o_man_boots.get()) && ((ItemStack)player.getInventory().armor.get(1)).is((Item)ItemRegistry.jack_o_man_leggings.get()) && ((ItemStack)player.getInventory().armor.get(2)).is((Item)ItemRegistry.jack_o_man_chestplate.get()) && ((ItemStack)player.getInventory().armor.get(3)).is((Item)ItemRegistry.jack_o_man_helmet.get());
    }

    @Override
    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Projectile shot = super.createProjectile(level, shooter, weapon, ammo, isCrit);
        if (shot instanceof DivineMagicProjectile) {
            Player player;
            DivineMagicProjectile d = (DivineMagicProjectile)shot;
            if (shooter instanceof Player && this.isJackoman(player = (Player)shooter)) {
                d.baseDamage = 6.0f;
            }
        }
        return shot;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocalizeUtils.magicDam(6));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

