/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.items.base.ItemMod;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class ItemSerenadeOfInfusion
extends ItemMod {
    protected int effectSec;

    public ItemSerenadeOfInfusion() {
        super(new Item.Properties().durability(15).component(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY.withEffectAdded(new MobEffectInstance(MobEffects.REGENERATION, 80, 2))));
        this.cooldown = 20;
        this.effectSec = 4;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.getHealth() < player.getMaxHealth()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, this.effectSec * 20, 2, true, false));
            player.playSound((SoundEvent)SoundRegistry.HEAL.get(), 1.0f, 1.0f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        NeutralMob mob;
        if (!(entity instanceof ServerPlayer || entity instanceof Monster || entity instanceof NeutralMob && (mob = (NeutralMob)entity).isAngry() || !(entity.getHealth() < entity.getMaxHealth()) || player.getCooldowns().isOnCooldown((Item)this))) {
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, this.effectSec * 20, 2, true, false));
            entity.playSound((SoundEvent)SoundRegistry.HEAL.get(), 1.0f, 1.0f);
            for (int i = 0; i < 7; ++i) {
                double d0 = entity.getRandom().nextGaussian() * 0.02;
                double d1 = entity.getRandom().nextGaussian() * 0.02;
                double d2 = entity.getRandom().nextGaussian() * 0.02;
                entity.level().addParticle((ParticleOptions)ParticleTypes.HEART, entity.getRandomX(1.0), entity.getRandomY() + 0.5, entity.getRandomZ(1.0), d0, d1, d2);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, entity, hand);
    }
}

