/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.vanilla;

import divinerpg.items.base.ItemMod;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemTeleportationCrystal
extends ItemMod {
    public ItemTeleportationCrystal() {
        super(new Item.Properties().durability(10));
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)player;
            BlockPos respawnPos = s.getRespawnPosition();
            if (respawnPos != null) {
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
                player.getCooldowns().addCooldown((Item)this, 160);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                player.changeDimension(s.findRespawnPositionAndUseSpawnBlock(true, DimensionTransition.PLAY_PORTAL_SOUND));
                return InteractionResultHolder.success((Object)stack);
            }
            Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "teleport.no_respawn", new Object[0]);
            player.displayClientMessage(message, true);
            return InteractionResultHolder.fail((Object)stack);
        }
        return super.use(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("teleport.respawn_point"));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

