/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.loot_modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SpawnBonusChestModifier
extends LootModifier {
    public static final MapCodec<SpawnBonusChestModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> SpawnBonusChestModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, SpawnBonusChestModifier::new));

    protected SpawnBonusChestModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack toAdd;
        if ((double)context.getRandom().nextFloat() <= 0.2) {
            toAdd = new ItemStack((ItemLike)BlockRegistry.divineLog.asItem(), 1 + context.getRandom().nextInt(3));
            generatedLoot.add((Object)toAdd);
        }
        if ((double)context.getRandom().nextFloat() <= 0.1) {
            toAdd = new ItemStack((ItemLike)ItemRegistry.tomato.get(), 1 + context.getRandom().nextInt(3));
            generatedLoot.add((Object)toAdd);
        }
        if ((double)context.getRandom().nextFloat() <= 0.4) {
            toAdd = new ItemStack((ItemLike)ItemRegistry.chicken_dinner.get(), 1);
            generatedLoot.add((Object)toAdd);
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

