/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.RecipeRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record InfusionTableRecipe(ItemStack input, Ingredient template, ItemStack output) implements Recipe<CraftingInput>
{
    private static final MapCodec<InfusionTableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("input").forGetter(table -> table.input), (App)Ingredient.CODEC.fieldOf("template").forGetter(table -> table.template), (App)ItemStack.CODEC.fieldOf("output").forGetter(table -> table.output)).apply((Applicative)instance, InfusionTableRecipe::new));
    public static final RecipeType<InfusionTableRecipe> TYPE = RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"infusion_table"));

    public boolean matches(CraftingInput inv, Level worldIn) {
        return inv.getItem(0).is(this.input.getItem()) && this.template.test(inv.getItem(1)) && inv.getItem(0).getCount() == this.input.getCount();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider access) {
        return this.output;
    }

    public NonNullList<Ingredient> getTemplate() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{this.input}));
        return ingredients;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.Serializers.INFUSION_TABLE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.Types.INFUSION_TABLE_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<InfusionTableRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionTableRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Nullable
        public static InfusionTableRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack input = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient template = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new InfusionTableRecipe(input, template, output);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, InfusionTableRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }

        public MapCodec<InfusionTableRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfusionTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

