/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class FluidRegistry {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"divinerpg");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"divinerpg");
    public static final DeferredHolder<FluidType, FluidType> SMOLDERING_TAR = FLUID_TYPES.register("smoldering_tar_fluid_type", () -> new FluidType(FluidType.Properties.create().canSwim(false).canHydrate(false).canDrown(true).density(1153).viscosity(8000).temperature(723).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL_LAVA)));
    public static final DeferredHolder<Fluid, BaseFlowingFluid> SMOLDERING_TAR_FLUID = FLUIDS.register("smoldering_tar", () -> new BaseFlowingFluid.Source(FluidRegistry.fluidProperties()){

        public int getSlopeFindDistance(LevelReader level) {
            return level.dimensionType().ultraWarm() ? 4 : 2;
        }

        public int getDropOff(LevelReader level) {
            return level.dimensionType().ultraWarm() ? 1 : 2;
        }

        public int getTickDelay(LevelReader level) {
            return level.dimensionType().ultraWarm() ? 30 : 50;
        }

        public int getSpreadDelay(Level level, BlockPos pos, FluidState state1, FluidState state2) {
            int i = this.getTickDelay((LevelReader)level);
            if (!(state1.isEmpty() || state2.isEmpty() || ((Boolean)state1.getValue((Property)FALLING)).booleanValue() || ((Boolean)state2.getValue((Property)FALLING)).booleanValue() || !(state2.getHeight((BlockGetter)level, pos) > state1.getHeight((BlockGetter)level, pos)) || level.getRandom().nextInt(4) == 0)) {
                i *= 4;
            }
            return i;
        }

        public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
            BlockPos blockpos = pos.above();
            if (level.getBlockState(blockpos).isAir() && !level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) {
                if (random.nextInt(100) == 0) {
                    double f = 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1);
                    double d0 = (double)pos.getX() + f;
                    double d1 = (double)pos.getY() + 0.9;
                    double d2 = (double)pos.getZ() + f;
                    level.addParticle((ParticleOptions)ParticleRegistry.TAR.get(), d0, d1, d2, 0.0, 0.005, 0.0);
                    level.playLocalSound(d0, d1, d2, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
                if (random.nextInt(200) == 0) {
                    level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
            }
        }

        private void fizz(LevelAccessor level, BlockPos pos) {
            level.levelEvent(1501, pos, 0);
        }

        protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
            this.fizz(level, pos);
        }
    });
    public static final DeferredHolder<Fluid, Fluid> SMOLDERING_TAR_FLUID_FLOWING = FLUIDS.register("flowing_smoldering_tar", () -> new BaseFlowingFluid.Flowing(FluidRegistry.fluidProperties()){

        private void fizz(LevelAccessor level, BlockPos pos) {
            level.levelEvent(1501, pos, 0);
        }

        protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
            this.fizz(level, pos);
        }

        protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState blockState, Direction dir, FluidState fluidState) {
            if (dir == Direction.DOWN) {
                FluidState fluidstate = level.getFluidState(pos);
                if (this.defaultFluidState().is(FluidTags.LAVA) && fluidstate.is(FluidTags.WATER)) {
                    if (blockState.getBlock() instanceof LiquidBlock) {
                        level.setBlock(pos, FluidRegistry.fireFluidPlaceBlockEvent(level, pos, pos, Blocks.STONE.defaultBlockState()), 3);
                    }
                    this.fizz(level, pos);
                    return;
                }
            }
            super.spreadTo(level, pos, blockState, dir, fluidState);
        }
    });
    public static final DeferredBlock<LiquidBlock> SMOLDERING_TAR_BLOCK = BlockRegistry.BLOCKS.register("smoldering_tar", () -> new LiquidBlock((FlowingFluid)SMOLDERING_TAR_FLUID.get(), BlockBehaviour.Properties.of().sound(SoundType.EMPTY).replaceable().pushReaction(PushReaction.DESTROY).randomTicks().mapColor(MapColor.COLOR_BLACK).noCollission().strength(100.0f).noLootTable()){

        public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (entity.isInFluidType()) {
                entity.makeStuckInBlock(state, new Vec3(0.4, 0.4, 0.4));
                entity.setRemainingFireTicks(12);
                if ((entity instanceof LivingEntity && !entity.fireImmune() && !((LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE) || !(entity instanceof LivingEntity) && !entity.fireImmune()) && entity.hurt(level.damageSources().source(DamageRegistry.TAR.getKey()), 4.0f)) {
                    entity.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + entity.getRandom().nextFloat() * 0.4f);
                }
            }
        }
    });

    private static BaseFlowingFluid.Properties fluidProperties() {
        return new BaseFlowingFluid.Properties(SMOLDERING_TAR, SMOLDERING_TAR_FLUID, SMOLDERING_TAR_FLUID_FLOWING).block(SMOLDERING_TAR_BLOCK).bucket(ItemRegistry.smoldering_tar_bucket);
    }

    public static BlockState fireFluidPlaceBlockEvent(LevelAccessor level, BlockPos pos, BlockPos liquidPos, BlockState state) {
        BlockEvent.FluidPlaceBlockEvent event = new BlockEvent.FluidPlaceBlockEvent(level, pos, liquidPos, state);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getNewState();
    }
}

