/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class LootTableRegistry {
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    private static final Set<ResourceLocation> READ_ONLY_LOOT_TABLES = Collections.unmodifiableSet(LOOT_TABLES);
    public static final ResourceLocation AMETHYST_GEODE = LootTableRegistry.registerTable("chests/overworld/amethyst_geode");
    public static final ResourceLocation ANCIENT_TOMB = LootTableRegistry.registerTable("chests/overworld/ancient_tomb");
    public static final ResourceLocation LIVESTOCK_MERCHANT_HUT = LootTableRegistry.registerTable("chests/overworld/livestock_merchant_hut");
    public static final ResourceLocation ICEIKA_DUNGEON = LootTableRegistry.registerTable("chests/iceika/dungeon");
    public static final ResourceLocation ICEIKA_HUT = LootTableRegistry.registerTable("chests/iceika/hut");
    public static final ResourceLocation GROGLIN_VILLAGE = LootTableRegistry.registerTable("chests/iceika/groglin_village");
    public static final ResourceLocation GRUZZORLUG_VILLAGE = LootTableRegistry.registerTable("chests/iceika/gruzzorlug_village");
    public static final ResourceLocation BANQUET_HALL = LootTableRegistry.registerTable("chests/arcana/banquet_hall");
    public static final ResourceLocation UTILITY_HALLWAY = LootTableRegistry.registerTable("chests/arcana/utility_hallway");
    public static final ResourceLocation EDEN_HUT = LootTableRegistry.registerTable("chests/twilight/eden/hut");
    public static final ResourceLocation SKYTHERN_HUT = LootTableRegistry.registerTable("chests/twilight/skythern/hut");
    public static final ResourceLocation WILDWOOD_HUT = LootTableRegistry.registerTable("chests/twilight/wildwood/hut");
    public static final ResourceLocation CRYPT = LootTableRegistry.registerTable("chests/vethea/crypt");
    public static final ResourceLocation KAROS_MADHOUSE = LootTableRegistry.registerTable("chests/vethea/karos_madhouse");
    public static final ResourceLocation QUADROTIC_POST = LootTableRegistry.registerTable("chests/vethea/quadrotic_post");
    public static final ResourceLocation RAGLOK_CHAMBER = LootTableRegistry.registerTable("chests/vethea/raglok_chamber");
    public static final ResourceLocation TEMPLE_BOTTOM = LootTableRegistry.registerTable("chests/vethea/temple_bottom");
    public static final ResourceLocation TEMPLE_MIDDLE = LootTableRegistry.registerTable("chests/vethea/temple_middle");
    public static final ResourceLocation TEMPLE_TOP = LootTableRegistry.registerTable("chests/vethea/temple_top");
    public static final ResourceLocation WRECK_HALL = LootTableRegistry.registerTable("chests/vethea/wreck_hall");
    public static final ResourceLocation ANCIENT_ENTITY = LootTableRegistry.registerTable("entities/ancient_entity");
    public static final ResourceLocation THE_WATCHER = LootTableRegistry.registerTable("entities/the_watcher");
    public static final ResourceLocation KING_OF_SCORCHERS = LootTableRegistry.registerTable("entities/king_of_scorchers");
    public static final ResourceLocation KITRA = LootTableRegistry.registerTable("entities/kitra");
    public static final ResourceLocation AYERACO = LootTableRegistry.registerTable("entities/ayeraco");
    public static final ResourceLocation DRAMIX = LootTableRegistry.registerTable("entities/dramix");
    public static final ResourceLocation PARASECTA = LootTableRegistry.registerTable("entities/parasecta");
    public static final ResourceLocation SUNSTORM = LootTableRegistry.registerTable("entities/sunstorm");
    public static final ResourceLocation TERMASECT = LootTableRegistry.registerTable("entities/termasect");
    public static final ResourceLocation ETERNAL_ARCHER = LootTableRegistry.registerTable("entities/eternal_archer");
    public static final ResourceLocation EXPERIENCED_CORI = LootTableRegistry.registerTable("entities/experienced_cori");
    public static final ResourceLocation VAMACHERON = LootTableRegistry.registerTable("entities/vamacheron");
    public static final ResourceLocation KAROT = LootTableRegistry.registerTable("entities/karot");
    public static final ResourceLocation TWILIGHT_DEMON = LootTableRegistry.registerTable("entities/twilight_demon");
    public static final ResourceLocation DENSOS = LootTableRegistry.registerTable("entities/densos");
    public static final ResourceLocation REYVOR = LootTableRegistry.registerTable("entities/reyvor");
    public static final ResourceLocation SOUL_FIEND = LootTableRegistry.registerTable("entities/soul_fiend");
    public static final ResourceLocation HIVE_QUEEN = LootTableRegistry.registerTable("entities/hive_queen");
    public static final ResourceLocation KAROS = LootTableRegistry.registerTable("entities/karos");
    public static final ResourceLocation LADY_LUNA = LootTableRegistry.registerTable("entities/lady_luna");
    public static final ResourceLocation QUADRO = LootTableRegistry.registerTable("entities/quadro");
    public static final ResourceLocation RAGLOK = LootTableRegistry.registerTable("entities/raglok");
    public static final ResourceLocation WRECK = LootTableRegistry.registerTable("entities/wreck");
    public static final ResourceLocation SNAPPER = LootTableRegistry.registerTable("entities/snapper");
    public static final ResourceLocation EHU = LootTableRegistry.registerTable("entities/ehu");
    public static final ResourceLocation HUSK = LootTableRegistry.registerTable("entities/husk");
    public static final ResourceLocation BROWN_GRIZZLE = LootTableRegistry.registerTable("entities/brown_grizzle");
    public static final ResourceLocation WHITE_GRIZZLE = LootTableRegistry.registerTable("entities/white_grizzle");
    public static final ResourceLocation STONE_GOLEM = LootTableRegistry.registerTable("entities/stone_golem");
    public static final ResourceLocation SMELTER = LootTableRegistry.registerTable("entities/smelter");
    public static final ResourceLocation LIVESTOCK_MERCHANT = LootTableRegistry.registerTable("entities/livestock_merchant");
    public static final ResourceLocation JACK_O_MAN = LootTableRegistry.registerTable("entities/jack_o_man");
    public static final ResourceLocation CYCLOPS = LootTableRegistry.registerTable("entities/cyclops");
    public static final ResourceLocation KOBBLIN = LootTableRegistry.registerTable("entities/kobblin");
    public static final ResourceLocation PUMPKIN_SPIDER = LootTableRegistry.registerTable("entities/pumpkin_spider");
    public static final ResourceLocation JUNGLE_BAT = LootTableRegistry.registerTable("entities/jungle_bat");
    public static final ResourceLocation JUNGLE_SPIDER = LootTableRegistry.registerTable("entities/jungle_spider");
    public static final ResourceLocation JUNGLE_DRAMCRYX = LootTableRegistry.registerTable("entities/jungle_dramcryx");
    public static final ResourceLocation SAGUARO_WORM = LootTableRegistry.registerTable("entities/saguaro_worm");
    public static final ResourceLocation DESERT_CRAWLER = LootTableRegistry.registerTable("entities/desert_crawler");
    public static final ResourceLocation ARID_WARRIOR = LootTableRegistry.registerTable("entities/arid_warrior");
    public static final ResourceLocation GLACON = LootTableRegistry.registerTable("entities/glacon");
    public static final ResourceLocation FROST = LootTableRegistry.registerTable("entities/frost");
    public static final ResourceLocation CRAB = LootTableRegistry.registerTable("entities/crab");
    public static final ResourceLocation KING_CRAB = LootTableRegistry.registerTable("entities/king_crab");
    public static final ResourceLocation AEQUOREA = LootTableRegistry.registerTable("entities/aequorea");
    public static final ResourceLocation SHARK = LootTableRegistry.registerTable("entities/shark");
    public static final ResourceLocation WHALE = LootTableRegistry.registerTable("entities/whale");
    public static final ResourceLocation LIOPLEURODON = LootTableRegistry.registerTable("entities/liopleurodon");
    public static final ResourceLocation DIAMOND_DAVE = LootTableRegistry.registerTable("entities/diamond_dave");
    public static final ResourceLocation RAINBOUR = LootTableRegistry.registerTable("entities/rainbour");
    public static final ResourceLocation MINER = LootTableRegistry.registerTable("entities/miner");
    public static final ResourceLocation ROTATICK = LootTableRegistry.registerTable("entities/rotatick");
    public static final ResourceLocation CAVE_CRAWLER = LootTableRegistry.registerTable("entities/cave_crawler");
    public static final ResourceLocation CAVECLOPS = LootTableRegistry.registerTable("entities/caveclops");
    public static final ResourceLocation THE_EYE = LootTableRegistry.registerTable("entities/the_eye");
    public static final ResourceLocation ENTHRALLED_DRAMCRYX = LootTableRegistry.registerTable("entities/enthralled_dramcryx");
    public static final ResourceLocation THE_GRUE = LootTableRegistry.registerTable("entities/the_grue");
    public static final ResourceLocation HELL_PIG = LootTableRegistry.registerTable("entities/hell_pig");
    public static final ResourceLocation HELL_SPIDER = LootTableRegistry.registerTable("entities/hell_spider");
    public static final ResourceLocation WILDFIRE = LootTableRegistry.registerTable("entities/wildfire");
    public static final ResourceLocation SCORCHER = LootTableRegistry.registerTable("entities/scorcher");
    public static final ResourceLocation ENDER_SCROUNGE = LootTableRegistry.registerTable("entities/ender_scrounge");
    public static final ResourceLocation ENDER_SPIDER = LootTableRegistry.registerTable("entities/ender_spider");
    public static final ResourceLocation ENDER_WATCHER = LootTableRegistry.registerTable("entities/ender_watcher");
    public static final ResourceLocation ENDER_TRIPLETS = LootTableRegistry.registerTable("entities/ender_triplets");
    public static final ResourceLocation CAULDRON_FISH = LootTableRegistry.registerTable("entities/cauldron_fish");
    public static final ResourceLocation PINK_GHOST_GLIDER = LootTableRegistry.registerTable("entities/pink_ghost_glider");
    public static final ResourceLocation BLUBBERTUSK = LootTableRegistry.registerTable("entities/blubbertusk");
    public static final ResourceLocation ROBBIN = LootTableRegistry.registerTable("entities/robbin");
    public static final ResourceLocation SNOW_SKIPPER = LootTableRegistry.registerTable("entities/snow_skipper");
    public static final ResourceLocation WOLPERTINGER = LootTableRegistry.registerTable("entities/wolpertinger");
    public static final ResourceLocation DOLOSSAL = LootTableRegistry.registerTable("entities/dolossal");
    public static final ResourceLocation MAMOTH = LootTableRegistry.registerTable("entities/mamoth");
    public static final ResourceLocation WORKSHOP_MERCHANT = LootTableRegistry.registerTable("entities/workshop_merchant");
    public static final ResourceLocation WORKSHOP_TINKERER = LootTableRegistry.registerTable("entities/workshop_tinkerer");
    public static final ResourceLocation ROLLUM = LootTableRegistry.registerTable("entities/rollum");
    public static final ResourceLocation PALE_ARCHER = LootTableRegistry.registerTable("entities/pale_archer");
    public static final ResourceLocation FROZEN_FLESH = LootTableRegistry.registerTable("entities/frozen_flesh");
    public static final ResourceLocation ALICANTO = LootTableRegistry.registerTable("entities/alicanto");
    public static final ResourceLocation SENG = LootTableRegistry.registerTable("entities/seng");
    public static final ResourceLocation SABEAR = LootTableRegistry.registerTable("entities/sabear");
    public static final ResourceLocation HASTREUS = LootTableRegistry.registerTable("entities/hastreus");
    public static final ResourceLocation GLACIDE = LootTableRegistry.registerTable("entities/glacide");
    public static final ResourceLocation FRACTITE = LootTableRegistry.registerTable("entities/fractite");
    public static final ResourceLocation GROGLIN_MERCHANT = LootTableRegistry.registerTable("entities/groglin_merchant");
    public static final ResourceLocation GROGLIN_SHARLATAN = LootTableRegistry.registerTable("entities/groglin_sharlatan");
    public static final ResourceLocation GROGLIN_HUNTER = LootTableRegistry.registerTable("entities/groglin_hunter");
    public static final ResourceLocation GROGLIN_RANGER = LootTableRegistry.registerTable("entities/groglin_ranger");
    public static final ResourceLocation GROGLIN_WARRIOR = LootTableRegistry.registerTable("entities/groglin_warrior");
    public static final ResourceLocation GROGLIN_CHIEFTAIN = LootTableRegistry.registerTable("entities/groglin_chieftain");
    public static final ResourceLocation GRUZZORLUG_MINER = LootTableRegistry.registerTable("entities/gruzzorlug_miner");
    public static final ResourceLocation GRUZZORLUG_CANNONEER = LootTableRegistry.registerTable("entities/gruzzorlug_cannoneer");
    public static final ResourceLocation GRUZZORLUG_COMMANDER = LootTableRegistry.registerTable("entities/gruzzorlug_commander");
    public static final ResourceLocation GRUZZORLUG_SWORDSMAN = LootTableRegistry.registerTable("entities/gruzzorlug_swordsman");
    public static final ResourceLocation GRUZZORLUG_KNIGHT = LootTableRegistry.registerTable("entities/gruzzorlug_knight");
    public static final ResourceLocation GRUZZORLUG_GENERAL = LootTableRegistry.registerTable("entities/gruzzorlug_general");
    public static final ResourceLocation CAPTAIN_MERIK = LootTableRegistry.registerTable("entities/captain_merik");
    public static final ResourceLocation DATTICON = LootTableRegistry.registerTable("entities/datticon");
    public static final ResourceLocation KAZARI = LootTableRegistry.registerTable("entities/kazari");
    public static final ResourceLocation LEORNA = LootTableRegistry.registerTable("entities/leorna");
    public static final ResourceLocation LORD_VATTICUS = LootTableRegistry.registerTable("entities/lord_vatticus");
    public static final ResourceLocation WAR_GENERAL = LootTableRegistry.registerTable("entities/war_general");
    public static final ResourceLocation ZELUS = LootTableRegistry.registerTable("entities/zelus");
    public static final ResourceLocation FYRACRYX = LootTableRegistry.registerTable("entities/fyracryx");
    public static final ResourceLocation GOLEM_OF_REJUVENATION = LootTableRegistry.registerTable("entities/golem_of_rejuvenation");
    public static final ResourceLocation PARATIKU = LootTableRegistry.registerTable("entities/paratiku");
    public static final ResourceLocation SEIMER = LootTableRegistry.registerTable("entities/seimer");
    public static final ResourceLocation WRAITH = LootTableRegistry.registerTable("entities/wraith");
    public static final ResourceLocation SKYRE = LootTableRegistry.registerTable("entities/skyre");
    public static final ResourceLocation RAZORBACK = LootTableRegistry.registerTable("entities/razorback");
    public static final ResourceLocation DEATH_HOUND = LootTableRegistry.registerTable("entities/death_hound");
    public static final ResourceLocation DUNGEON_CONSTRUCTOR = LootTableRegistry.registerTable("entities/dungeon_constructor");
    public static final ResourceLocation DUNGEON_PRISONER = LootTableRegistry.registerTable("entities/dungeon_prisoner");
    public static final ResourceLocation DUNGEON_DEMON = LootTableRegistry.registerTable("entities/dungeon_demon");
    public static final ResourceLocation ROAMER = LootTableRegistry.registerTable("entities/roamer");
    public static final ResourceLocation DEATHCRYX = LootTableRegistry.registerTable("entities/deathcryx");
    public static final ResourceLocation LIVING_STATUE = LootTableRegistry.registerTable("entities/living_statue");
    public static final ResourceLocation GEM_FIN = LootTableRegistry.registerTable("entities/gem_fin");
    public static final ResourceLocation GLINTHOP = LootTableRegistry.registerTable("entities/glinthop");
    public static final ResourceLocation EDEN_TOMO = LootTableRegistry.registerTable("entities/tomo");
    public static final ResourceLocation EDEN_CADILLION = LootTableRegistry.registerTable("entities/cadillion");
    public static final ResourceLocation GREENFEET = LootTableRegistry.registerTable("entities/greenfeet");
    public static final ResourceLocation MADIVEL = LootTableRegistry.registerTable("entities/madivel");
    public static final ResourceLocation SUN_ARCHER = LootTableRegistry.registerTable("entities/sun_archer");
    public static final ResourceLocation WEAK_CORI = LootTableRegistry.registerTable("entities/weak_cori");
    public static final ResourceLocation MOON_WOLF = LootTableRegistry.registerTable("entities/moon_wolf");
    public static final ResourceLocation WILDWOOD_TOMO = LootTableRegistry.registerTable("entities/wildwood_tomo");
    public static final ResourceLocation WILDWOOD_CADILLION = LootTableRegistry.registerTable("entities/wildwood_cadillion");
    public static final ResourceLocation EPIPHITE = LootTableRegistry.registerTable("entities/epiphite");
    public static final ResourceLocation BEHEMOTH = LootTableRegistry.registerTable("entities/behemoth");
    public static final ResourceLocation TERMID = LootTableRegistry.registerTable("entities/termid");
    public static final ResourceLocation VEREK = LootTableRegistry.registerTable("entities/verek");
    public static final ResourceLocation WILDWOOD_GOLEM = LootTableRegistry.registerTable("entities/wildwood_golem");
    public static final ResourceLocation MAGE = LootTableRegistry.registerTable("entities/mage");
    public static final ResourceLocation APALACHIA_TOMO = LootTableRegistry.registerTable("entities/apalachia_tomo");
    public static final ResourceLocation APALACHIA_CADILLION = LootTableRegistry.registerTable("entities/apalachia_cadillion");
    public static final ResourceLocation ENCHANTED_WARRIOR = LootTableRegistry.registerTable("entities/enchanted_warrior");
    public static final ResourceLocation APALACHIA_GOLEM = LootTableRegistry.registerTable("entities/apalachia_golem");
    public static final ResourceLocation ENCHANTED_ARCHER = LootTableRegistry.registerTable("entities/enchanted_archer");
    public static final ResourceLocation SPELLBINDER = LootTableRegistry.registerTable("entities/spellbinder");
    public static final ResourceLocation SAMEK = LootTableRegistry.registerTable("entities/samek");
    public static final ResourceLocation SKYTHERN_FIEND = LootTableRegistry.registerTable("entities/skythern_fiend");
    public static final ResourceLocation SKYTHERN_GOLEM = LootTableRegistry.registerTable("entities/skythern_golem");
    public static final ResourceLocation MEGALITH = LootTableRegistry.registerTable("entities/megalith");
    public static final ResourceLocation SKYTHERN_ARCHER = LootTableRegistry.registerTable("entities/skythern_archer");
    public static final ResourceLocation MYSTIC = LootTableRegistry.registerTable("entities/mystic");
    public static final ResourceLocation ADVANCED_CORI = LootTableRegistry.registerTable("entities/advanced_cori");
    public static final ResourceLocation ANGRY_GLINTHOP = LootTableRegistry.registerTable("entities/angry_glinthop");
    public static final ResourceLocation MORTUM_CADILLION = LootTableRegistry.registerTable("entities/mortum_cadillion");
    public static final ResourceLocation SOUL_SPIDER = LootTableRegistry.registerTable("entities/soul_spider");
    public static final ResourceLocation BASILISK = LootTableRegistry.registerTable("entities/basilisk");
    public static final ResourceLocation DEMON_OF_DARKNESS = LootTableRegistry.registerTable("entities/demon_of_darkness");
    public static final ResourceLocation SOUL_STEALER = LootTableRegistry.registerTable("entities/soul_stealer");
    public static final ResourceLocation TWILIGHT_ARCHER = LootTableRegistry.registerTable("entities/twilight_archer");
    public static final ResourceLocation SORCERER = LootTableRegistry.registerTable("entities/sorcerer");
    public static final ResourceLocation THE_HUNGER = LootTableRegistry.registerTable("entities/the_hunger");
    public static final ResourceLocation CRYPT_KEEPER = LootTableRegistry.registerTable("entities/crypt_keeper");
    public static final ResourceLocation MYSTERIOUS_MAN_LAYER_1 = LootTableRegistry.registerTable("entities/mysterious_man_layer_1");
    public static final ResourceLocation ACID_HAG = LootTableRegistry.registerTable("entities/acid_hag");
    public static final ResourceLocation CYMESOID = LootTableRegistry.registerTable("entities/cymesoid");
    public static final ResourceLocation DREAMWRECKER = LootTableRegistry.registerTable("entities/dreamwrecker");
    public static final ResourceLocation DUO = LootTableRegistry.registerTable("entities/duo");
    public static final ResourceLocation ENT = LootTableRegistry.registerTable("entities/ent");
    public static final ResourceLocation LORGA = LootTableRegistry.registerTable("entities/lorga");
    public static final ResourceLocation SHADAHIER = LootTableRegistry.registerTable("entities/shadahier");
    public static final ResourceLocation HIVE_SOLDIER = LootTableRegistry.registerTable("entities/hive_soldier");
    public static final ResourceLocation HOVER_STINGER = LootTableRegistry.registerTable("entities/hover_stinger");
    public static final ResourceLocation TEMPLE_GUARDIAN = LootTableRegistry.registerTable("entities/temple_guardian");
    public static final ResourceLocation MYSTERIOUS_MAN_LAYER_2 = LootTableRegistry.registerTable("entities/mysterious_man_layer_2");
    public static final ResourceLocation BIPHRON = LootTableRegistry.registerTable("entities/biphron");
    public static final ResourceLocation GORGOSION = LootTableRegistry.registerTable("entities/gorgosion");
    public static final ResourceLocation INSECT_FOURTEEN = LootTableRegistry.registerTable("entities/insect_fourteen");
    public static final ResourceLocation MANDRAGORA = LootTableRegistry.registerTable("entities/mandragora");
    public static final ResourceLocation TWINS = LootTableRegistry.registerTable("entities/twins");
    public static final ResourceLocation VERMENOUS = LootTableRegistry.registerTable("entities/vermenous");
    public static final ResourceLocation MYSTERIOUS_MAN_LAYER_3 = LootTableRegistry.registerTable("entities/mysterious_man_layer_3");
    public static final ResourceLocation BOHEMITE = LootTableRegistry.registerTable("entities/bohemite");
    public static final ResourceLocation GALROID = LootTableRegistry.registerTable("entities/galroid");
    public static final ResourceLocation KAZROTIC = LootTableRegistry.registerTable("entities/kazrotic");
    public static final ResourceLocation LHEIVA = LootTableRegistry.registerTable("entities/lheiva");
    public static final ResourceLocation LORGA_FLIGHT = LootTableRegistry.registerTable("entities/lorga_flight");
    public static final ResourceLocation TOCAXIN = LootTableRegistry.registerTable("entities/tocaxin");
    public static final ResourceLocation DISSIMENT = LootTableRegistry.registerTable("entities/dissiment");
    public static final ResourceLocation HELIO = LootTableRegistry.registerTable("entities/helio");
    public static final ResourceLocation VHRAAK = LootTableRegistry.registerTable("entities/vhraak");
    public static final ResourceLocation FAKE_VHRAAK = LootTableRegistry.registerTable("entities/fake_vhraak");
    public static final ResourceLocation ZONE = LootTableRegistry.registerTable("entities/zone");
    public static final ResourceLocation ZORAGON = LootTableRegistry.registerTable("entities/zoragon");

    private static ResourceLocation registerTable(String id) {
        return LootTableRegistry.register(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> all() {
        return READ_ONLY_LOOT_TABLES;
    }
}

