/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import divinerpg.DivineRPG;
import divinerpg.registries.ItemRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelPropRegistry {
    public static void init() {
        DivineRPG.LOGGER.info("[DivineRPG] Attached model properties");
        ModelPropRegistry.registerBow((Item)ItemRegistry.hunter_bow.get(), (Item)ItemRegistry.shadow_bow.get(), (Item)ItemRegistry.icicle_bow.get(), (Item)ItemRegistry.inferno_bow.get(), (Item)ItemRegistry.soulfire_bow.get(), (Item)ItemRegistry.snowstorm_bow.get(), (Item)ItemRegistry.ender_bow.get(), (Item)ItemRegistry.eden_bow.get(), (Item)ItemRegistry.wildwood_bow.get(), (Item)ItemRegistry.apalachia_bow.get(), (Item)ItemRegistry.skythern_bow.get(), (Item)ItemRegistry.mortum_bow.get(), (Item)ItemRegistry.halite_bow.get(), (Item)ItemRegistry.twilight_bow.get(), (Item)ItemRegistry.teaker_bow.get(), (Item)ItemRegistry.amthirmis_bow.get(), (Item)ItemRegistry.darven_bow.get(), (Item)ItemRegistry.cermile_bow.get(), (Item)ItemRegistry.pardimal_bow.get(), (Item)ItemRegistry.quadrotic_bow.get(), (Item)ItemRegistry.karos_bow.get(), (Item)ItemRegistry.heliosis_bow.get(), (Item)ItemRegistry.arksiane_bow.get(), (Item)ItemRegistry.everfright.get(), (Item)ItemRegistry.meriks_missile.get());
        ModelPropRegistry.registerShield((Item)ItemRegistry.realmite_shield.get(), (Item)ItemRegistry.arlemite_shield.get(), (Item)ItemRegistry.rupee_shield.get(), (Item)ItemRegistry.eden_shield.get(), (Item)ItemRegistry.wildwood_shield.get(), (Item)ItemRegistry.apalachia_shield.get(), (Item)ItemRegistry.skythern_shield.get(), (Item)ItemRegistry.mortum_shield.get(), (Item)ItemRegistry.halite_shield.get());
    }

    public static void registerBow(Item ... bows) {
        for (Item bow : bows) {
            ItemProperties.register((Item)bow, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (stack, level, entity, i) -> {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.getUseItem() != stack ? 0.0f : (float)(stack.getUseDuration(entity) - entity.getUseItemRemainingTicks()) / 20.0f;
            });
            ItemProperties.register((Item)bow, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (stack, level, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }
    }

    public static void registerShield(Item ... shields) {
        for (Item shield : shields) {
            ItemProperties.register((Item)shield.asItem(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"blocking"), (stack, world, entity, i) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        }
    }
}

