/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import divinerpg.registries.LevelRegistry;
import divinerpg.util.UniversalPosition;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface DivinePortalLogic
extends Portal {
    default public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(true)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @Nullable
    default public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        BlockPos center;
        DimensionTransition d = this.getSimpleConnection(level, entity, pos);
        if (d != null) {
            return d;
        }
        UniversalPosition target = this.getTargetLocation(level, entity, pos);
        if (target == null) {
            return null;
        }
        MinecraftServer server = level.getServer();
        ServerLevel targetLevel = target.level(server);
        BlockPos targetPos = this.lookForNearbyPortal(targetLevel, entity, center = this.findSuitableLocation(targetLevel, entity, target.blockPos(), 0));
        if (targetPos != null) {
            this.link(level, pos, targetLevel, targetPos);
            return DivinePortalLogic.transitionTo(targetLevel, entity, targetPos);
        }
        for (int tries = 1; tries < 10 && !this.hasSpace(targetLevel, targetPos = this.findSuitableLocation(targetLevel, entity, center, tries)); ++tries) {
            if (tries != 9) continue;
            targetPos = center;
        }
        return DivinePortalLogic.transitionTo(targetLevel, entity, this.placeAndLink(level, pos, targetLevel, targetPos, entity));
    }

    public ResourceKey<Level> rootDimension();

    public boolean hasSpace(ServerLevel var1, BlockPos var2);

    @Nullable
    default public DimensionTransition getSimpleConnection(ServerLevel level, Entity entity, BlockPos pos) {
        return null;
    }

    @Nullable
    default public UniversalPosition getTargetLocation(ServerLevel source, Entity entity, BlockPos origin) {
        return new UniversalPosition(this.rootDimension(), DivinePortalLogic.scalePosition(origin, source.dimensionType(), source.getServer().getLevel(this.rootDimension()).dimensionType()));
    }

    @Nullable
    default public BlockPos lookForNearbyPortal(ServerLevel level, Entity entity, BlockPos center) {
        return null;
    }

    default public BlockPos findSuitableLocation(ServerLevel level, Entity entity, BlockPos center, int attempt) {
        ResourceKey d = level.dimension();
        RandomSource random = level.getRandom();
        BlockPos pos = center.offset(random.nextInt(1 + (attempt << 1)) - attempt, 0, random.nextInt(1 + (attempt << 1)) - attempt);
        BlockPos.MutableBlockPos m = d == LevelRegistry.EDEN || d == LevelRegistry.WILDWOOD || d == LevelRegistry.APALACHIA ? Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 127, 250, 0, (LevelReader)level, random, pos).mutable() : (d == LevelRegistry.MORTUM ? Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, 20, 125, 0, (LevelReader)level, random, pos).mutable() : (d == LevelRegistry.VETHEA ? Surface.getSurface(Surface.Surface_Type.LOWEST_GROUND, Surface.Mode.FULL, -55, 32, 0, (LevelReader)level, random, pos).mutable() : Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, level.getMinBuildHeight() + 5, level.dimensionType().logicalHeight(), 0, (LevelReader)level, random, pos).mutable()));
        while (level.getBlockState((BlockPos)m).is(Blocks.WATER)) {
            m.move(0, 1, 0);
        }
        return m;
    }

    default public void link(ServerLevel originLevel, BlockPos originPos, ServerLevel targetLevel, BlockPos targetPos) {
    }

    default public BlockPos placeAndLink(ServerLevel originLevel, BlockPos originPos, ServerLevel targetLevel, BlockPos targetPos, Entity entity) {
        return targetPos;
    }

    public static DimensionTransition transitionTo(ServerLevel level, Entity entity, BlockPos pos) {
        return DivinePortalLogic.transitionTo(level, entity, Vec3.atBottomCenterOf((Vec3i)pos));
    }

    public static DimensionTransition transitionTo(ServerLevel level, Entity entity, Vec3 pos) {
        return new DimensionTransition(level, pos, entity.getKnownMovement(), entity.getYRot(), entity.getXRot(), false, DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    public static BlockPos scalePosition(BlockPos pos, DimensionType originDimension, DimensionType targetDimension) {
        double scale = DimensionType.getTeleportationScale((DimensionType)originDimension, (DimensionType)targetDimension);
        return new BlockPos((int)((double)pos.getX() * scale), pos.getZ(), (int)((double)pos.getZ() * scale));
    }

    default public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = level.getGameRules().getInt(player.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY);
        } else {
            n = 0;
        }
        return n;
    }
}

