/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileInventoryHelper
implements Container {
    private final ItemStackHandler chestContents;
    private Predicate<Player> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda;
    private final Notify openInventoryNotificationLambda;
    private final Notify closeInventoryNotificationLambda;

    private TileInventoryHelper(int size) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> {};
        this.chestContents = new ItemStackHandler(size);
    }

    private TileInventoryHelper(int size, Predicate<Player> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> {};
        this.chestContents = new ItemStackHandler(size);
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public static TileInventoryHelper createForBlockEntity(int size, Predicate<Player> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        return new TileInventoryHelper(size, canPlayerAccessInventoryLambda, markDirtyNotificationLambda);
    }

    public static TileInventoryHelper createForClientSideContainer(int size) {
        return new TileInventoryHelper(size);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.chestContents.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.chestContents.deserializeNBT(provider, nbt);
    }

    public boolean stillValid(Player player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.chestContents.isItemValid(index, stack);
    }

    public void setChanged() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void startOpen(Player player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void stopOpen(Player player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int getContainerSize() {
        return this.chestContents.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.chestContents.getSlots(); ++i) {
            if (this.chestContents.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return this.chestContents.getStackInSlot(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.chestContents.extractItem(index, count, false);
    }

    public ItemStack removeItemNoUpdate(int index) {
        int maxPossibleItemStackSize = this.chestContents.getSlotLimit(index);
        return this.chestContents.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void setItem(int index, ItemStack stack) {
        this.chestContents.setStackInSlot(index, stack);
    }

    public void clearContent() {
        for (int i = 0; i < this.chestContents.getSlots(); ++i) {
            this.chestContents.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

