/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world;

import com.google.common.collect.ImmutableList;
import divinerpg.registries.FeatureRegistry;
import divinerpg.util.Utils;
import divinerpg.world.feature.config.EllipsoidConfig;
import divinerpg.world.feature.config.RuleTestConfig;
import divinerpg.world.feature.config.tree.TreeConfig;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public final class ConfiguredFeatureKeys {
    public static final ResourceKey<ConfiguredFeature<?, ?>> DIVINE_TREE = ConfiguredFeatureKeys.registerKey("divine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TAR_LAKE = ConfiguredFeatureKeys.registerKey("tar_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TWILIGHT_TAR_LAKE = ConfiguredFeatureKeys.registerKey("twilight_tar_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WILDWOOD_TREE = ConfiguredFeatureKeys.registerKey("wildwood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> APALACHIA_TREE = ConfiguredFeatureKeys.registerKey("apalachia_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SKYTHERN_TREE = ConfiguredFeatureKeys.registerKey("skythern_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SKYTHERN_BUSH = ConfiguredFeatureKeys.registerKey("skythern_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MORTUM_TREE = ConfiguredFeatureKeys.registerKey("mortum_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MORTUM_BUSH = ConfiguredFeatureKeys.registerKey("mortum_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EDEN_TREE = ConfiguredFeatureKeys.registerKey("eden_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> EDEN_BUSH = ConfiguredFeatureKeys.registerKey("eden_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DUNCAP = ConfiguredFeatureKeys.registerKey("duncap");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIVERSPINE_TREE = ConfiguredFeatureKeys.registerKey("shiverspine_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DEAD_SHIVERSPINE = ConfiguredFeatureKeys.registerKey("dead_shiverspine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AURORAOAK_TREE = ConfiguredFeatureKeys.registerKey("auroraoak_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COZYBARK_TREE = ConfiguredFeatureKeys.registerKey("cozybark_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COZYBARK_STUMP = ConfiguredFeatureKeys.registerKey("cozybark_stump");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FRACTAL_TREE = ConfiguredFeatureKeys.registerKey("fractal_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STREAMLEAF_TREE = ConfiguredFeatureKeys.registerKey("streamleaf_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOWSPROUT = ConfiguredFeatureKeys.registerKey("glowsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LOWSPROUT = ConfiguredFeatureKeys.registerKey("lowsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SLOWSPROUT = ConfiguredFeatureKeys.registerKey("slowsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SHIVERSPINE_BUSH = ConfiguredFeatureKeys.registerKey("shiverspine_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COZYBARK_BUSH = ConfiguredFeatureKeys.registerKey("cozybark_bush");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEOTHERMAL_POND = ConfiguredFeatureKeys.registerKey("geothermal_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLACIAL_POND = ConfiguredFeatureKeys.registerKey("glacial_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRITTLE_POND = ConfiguredFeatureKeys.registerKey("brittle_pond");
    public static final ResourceKey<ConfiguredFeature<?, ?>> THERMAL_VENT = ConfiguredFeatureKeys.registerKey("thermal_vent");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FROZEN_LIGHT = ConfiguredFeatureKeys.registerKey("frozen_light");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRITTLE_PLANTS = ConfiguredFeatureKeys.registerKey("brittle_plants");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRITTLE_CAVES_VEGETATION = ConfiguredFeatureKeys.registerKey("brittle_caves_vegetation");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WHALE_SKELETON = ConfiguredFeatureKeys.registerKey("whale_skeleton");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SNOW_COVERAGE = ConfiguredFeatureKeys.registerKey("snow_coverage");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SNOW_SPREADER = ConfiguredFeatureKeys.registerKey("snow_spreader");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCANA_DUNGEON = ConfiguredFeatureKeys.registerKey("arcana_dungeon");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCANA_TAR_LAKE = ConfiguredFeatureKeys.registerKey("arcana_tar_lake");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ARCANITE_VINES = ConfiguredFeatureKeys.registerKey("arcanite_vines");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREAM_ASTEROID = ConfiguredFeatureKeys.registerKey("dream_asteroid");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREAM_ASTEROID_SMALL = ConfiguredFeatureKeys.registerKey("dream_asteroid_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> FIREWOOD_TREE = ConfiguredFeatureKeys.registerKey("firewood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREAMWOOD_TREE = ConfiguredFeatureKeys.registerKey("dreamwood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> HYREWOOD_TREE = ConfiguredFeatureKeys.registerKey("hyrewood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MINTWOOD_TREE = ConfiguredFeatureKeys.registerKey("mintwood_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BEAM = ConfiguredFeatureKeys.registerKey("beam");

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ConfiguredFeatureKeys.register(context, DIVINE_TREE, (Feature)FeatureRegistry.DIVINE_TREE.get(), new TreeConfig(Utils.getBlockState("divine_log"), (BlockState)Utils.getBlockState("divine_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, TAR_LAKE, Feature.LAKE, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("smoldering_tar")), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.STONE)));
        ConfiguredFeatureKeys.register(context, TWILIGHT_TAR_LAKE, Feature.LAKE, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("smoldering_tar")), (BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("twilight_stone"))));
        ConfiguredFeatureKeys.register(context, WILDWOOD_TREE, (Feature)FeatureRegistry.WILDWOOD_TREE.get(), new TreeConfig(Utils.getBlockState("wildwood_log"), (BlockState)Utils.getBlockState("wildwood_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, APALACHIA_TREE, (Feature)FeatureRegistry.APALACHIA_TREE.get(), new TreeConfig(Utils.getBlockState("apalachia_log"), (BlockState)Utils.getBlockState("apalachia_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SKYTHERN_TREE, (Feature)FeatureRegistry.SKYTHERN_TREE.get(), new TreeConfig(Utils.getBlockState("skythern_log"), (BlockState)Utils.getBlockState("skythern_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SKYTHERN_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("skythern_log"), (BlockState)Utils.getBlockState("skythern_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, MORTUM_TREE, (Feature)FeatureRegistry.MORTUM_TREE.get(), new TreeConfig(Utils.getBlockState("mortum_log"), (BlockState)Utils.getBlockState("mortum_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, MORTUM_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("mortum_log"), (BlockState)Utils.getBlockState("mortum_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, EDEN_TREE, (Feature)FeatureRegistry.EDEN_TREE.get(), new TreeConfig(Utils.getBlockState("eden_log"), (BlockState)Utils.getBlockState("eden_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, EDEN_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("eden_log"), (BlockState)Utils.getBlockState("eden_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, DUNCAP, (Feature)FeatureRegistry.DUNCAP.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, SHIVERSPINE_TREE, (Feature)FeatureRegistry.SHIVERSPINE_TREE.get(), new TreeConfig(Utils.getBlockState("shiverspine_log"), (BlockState)Utils.getBlockState("brittle_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, DEAD_SHIVERSPINE, (Feature)FeatureRegistry.DEAD_SHIVERSPINE.get(), new TreeConfig(Utils.getBlockState("shiverspine_log"), Blocks.DIRT.defaultBlockState(), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, AURORAOAK_TREE, (Feature)FeatureRegistry.AURORAOAK_TREE.get(), new TreeConfig(Utils.getBlockState("auroraoak_log"), (BlockState)Utils.getBlockState("auroraoak_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, COZYBARK_TREE, (Feature)FeatureRegistry.COZYBARK_TREE.get(), new TreeConfig(Utils.getBlockState("cozybark_log"), (BlockState)Utils.getBlockState("cozybark_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, COZYBARK_STUMP, (Feature)FeatureRegistry.STUMP.get(), new TreeConfig(Utils.getBlockState("cozybark_log"), Utils.getBlockState("roofbell"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, GLOWSPROUT, (Feature)FeatureRegistry.GLOWSPROUT.get(), new TreeConfig(Utils.getBlockState("glowsprout_stem"), Utils.getBlockState("glowsprout_bulb"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, LOWSPROUT, (Feature)FeatureRegistry.LOWSPROUT.get(), new TreeConfig(Utils.getBlockState("lowsprout_stem"), Utils.getBlockState("lowsprout_bulb"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SLOWSPROUT, (Feature)FeatureRegistry.SLOWSPROUT.get(), new TreeConfig(Utils.getBlockState("slowsprout_stem"), Utils.getBlockState("slowsprout_bulb"), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, SHIVERSPINE_BUSH, (Feature)FeatureRegistry.BUSH.get(), new TreeConfig(Utils.getBlockState("shiverspine_log"), (BlockState)Utils.getBlockState("brittle_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, COZYBARK_BUSH, (Feature)FeatureRegistry.COZYBARK_BUSH.get(), new TreeConfig(Utils.getBlockState("cozybark_log"), (BlockState)Utils.getBlockState("cozybark_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, STREAMLEAF_TREE, (Feature)FeatureRegistry.STREAMLEAF_TREE.get(), new TreeConfig(Utils.getBlockState("streamleaf_log"), (BlockState)Utils.getBlockState("streamleaf_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, GEOTHERMAL_POND, (Feature)FeatureRegistry.GEOTHERMAL_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, GLACIAL_POND, (Feature)FeatureRegistry.GLACIAL_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, BRITTLE_POND, (Feature)FeatureRegistry.BRITTLE_POND.get(), new RuleTestConfig((List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, THERMAL_VENT, (Feature)FeatureRegistry.THERMAL_VENT.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, BRITTLE_PLANTS, (Feature)FeatureRegistry.BRITTLE_PLANTS.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, BRITTLE_CAVES_VEGETATION, (Feature)FeatureRegistry.BRITTLE_CAVES_VEGETATION.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, WHALE_SKELETON, (Feature)FeatureRegistry.WHALE_SKELETON.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, SNOW_COVERAGE, (Feature)FeatureRegistry.SNOW_COVERAGE.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, SNOW_SPREADER, (Feature)FeatureRegistry.SNOW_SPREADER.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, FRACTAL_TREE, (Feature)FeatureRegistry.FRACTAL_TREE.get(), new TreeConfig(Blocks.PACKED_ICE.defaultBlockState(), Blocks.ICE.defaultBlockState(), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, ARCANA_DUNGEON, (Feature)FeatureRegistry.ARCANA_DUNGEON.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, ARCANA_TAR_LAKE, Feature.LAKE, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("smoldering_tar")), (BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("soul_sludge_breakable"))));
        ConfiguredFeatureKeys.register(context, ARCANITE_VINES, (Feature)FeatureRegistry.ARCANITE_VINES.get(), NoneFeatureConfiguration.INSTANCE);
        ConfiguredFeatureKeys.register(context, DREAM_ASTEROID, (Feature)FeatureRegistry.ELLIPSOID.get(), new EllipsoidConfig((BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("dream_stone")), 2, 7, (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, DREAM_ASTEROID_SMALL, (Feature)FeatureRegistry.ELLIPSOID.get(), new EllipsoidConfig((BlockStateProvider)BlockStateProvider.simple((Block)Utils.getBlock("dream_stone")), 1, 2, (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, FIREWOOD_TREE, (Feature)FeatureRegistry.FIREWOOD_TREE.get(), new TreeConfig(Utils.getBlockState("firewood_log"), (BlockState)Utils.getBlockState("firewood_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, DREAMWOOD_TREE, (Feature)FeatureRegistry.DREAMWOOD_TREE.get(), new TreeConfig(Utils.getBlockState("dreamwood_log"), (BlockState)Utils.getBlockState("dreamwood_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, HYREWOOD_TREE, (Feature)FeatureRegistry.DREAMWOOD_TREE.get(), new TreeConfig(Utils.getBlockState("hyrewood_log"), (BlockState)Utils.getBlockState("hyrewood_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, MINTWOOD_TREE, (Feature)FeatureRegistry.FIREWOOD_TREE.get(), new TreeConfig(Utils.getBlockState("mintwood_log"), (BlockState)Utils.getBlockState("mintwood_leaves").setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), (List<RuleTest>)ImmutableList.of()));
        ConfiguredFeatureKeys.register(context, BEAM, (Feature)FeatureRegistry.BEAM.get(), NoneFeatureConfiguration.INSTANCE);
    }

    public static void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Feature<NoneFeatureConfiguration> feature) {
        ConfiguredFeatureKeys.register(context, key, feature, FeatureConfiguration.NONE);
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }

    public static Holder.Reference<ConfiguredFeature<?, ?>> getConfiguredFeature(WorldGenLevel level, ResourceKey<ConfiguredFeature<?, ?>> key) {
        return (Holder.Reference)level.getServer().registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(key).get();
    }
}

