/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.registries.BlockRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class Exposure
extends Feature<NoneFeatureConfiguration> {
    public static final BlockState exposedScorchalt = ((Block)BlockRegistry.exposedScorchalt.get()).defaultBlockState();
    public static final BlockState rayStone = ((Block)BlockRegistry.rayStone.get()).defaultBlockState();

    public Exposure() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), (ChunkGenerator)null, context.random(), context.origin());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator gen, RandomSource random, BlockPos origin) {
        origin = new BlockPos(origin.getX() & 0xFFFFFFF0, 0, origin.getZ() & 0xFFFFFFF0);
        BlockState state = rayStone;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin.getX() | x, level.getMaxBuildHeight(), origin.getZ() | z);
                while (pos.getY() > 127 && (state = level.getBlockState((BlockPos)pos)).isAir()) {
                    pos.move(0, -1, 0);
                }
                if (!state.is(BlockRegistry.scorchalt)) continue;
                Exposure.expose(level, (BlockPos)pos);
            }
        }
        return true;
    }

    public static void expose(WorldGenLevel level, BlockPos pos) {
        List<Supplier> positions = List.of(() -> pos.offset(1, 2, 0), () -> pos.offset(-1, 2, 0), () -> pos.offset(0, 2, 1), () -> pos.offset(0, 2, -1), () -> pos.offset(1, 2, 1), () -> pos.offset(-1, 2, -1), () -> pos.offset(-1, 2, 1), () -> pos.offset(1, 2, -1), () -> pos.offset(2, 2, 0), () -> pos.offset(-2, 2, 0), () -> pos.offset(0, 2, 2), () -> pos.offset(0, 2, -2));
        for (Supplier p : positions) {
            if (level.isEmptyBlock((BlockPos)p.get())) continue;
            return;
        }
        boolean b = true;
        positions = List.of(() -> pos.offset(3, 2, 0), () -> pos.offset(-3, 2, 0), () -> pos.offset(0, 2, 3), () -> pos.offset(0, 2, -3), () -> pos.offset(2, 2, 1), () -> pos.offset(2, 2, -1), () -> pos.offset(-2, 2, -1), () -> pos.offset(-2, 2, 1), () -> pos.offset(1, 2, 2), () -> pos.offset(1, 2, -2), () -> pos.offset(-1, 2, -2), () -> pos.offset(-1, 2, 2));
        for (Supplier p : positions) {
            if (level.isEmptyBlock((BlockPos)p.get())) continue;
            b = false;
            break;
        }
        if (b) {
            level.setBlock(pos, rayStone, 2);
            level.setBlock(pos.below(), exposedScorchalt, 2);
        } else {
            level.setBlock(pos, exposedScorchalt, 2);
        }
    }
}

