/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.decoration.GemClusterConfig;
import divinerpg.world.placement.Surface;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class GemCluster
extends Feature<GemClusterConfig> {
    public GemCluster() {
        super(GemClusterConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<GemClusterConfig> context) {
        return this.place((GemClusterConfig)context.config(), context.level(), context.chunkGenerator(), context.random(), context.origin());
    }

    public boolean place(GemClusterConfig config, WorldGenLevel level, ChunkGenerator c, RandomSource random, BlockPos origin) {
        if (GemCluster.canBeHere(level, random, origin, config.rules)) {
            if (random.nextFloat() <= 0.2f) {
                this.setBlock((LevelWriter)level, origin, config.buddingBlock);
                this.populateWithClusters(level, random, origin, config.cluster, 1.0f);
            } else if (random.nextFloat() <= 0.25f) {
                BlockState state = level.getBlockState(origin.above());
                if (Surface.hasSpace(state)) {
                    this.setBlock((LevelWriter)level, origin.above(), (BlockState)((BlockState)config.cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
                } else {
                    state = level.getBlockState(origin.below());
                    if (Surface.hasSpace(state)) {
                        this.setBlock((LevelWriter)level, origin.below(), (BlockState)((BlockState)config.cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
                    } else {
                        state = level.getBlockState(origin.north());
                        if (Surface.hasSpace(state)) {
                            this.setBlock((LevelWriter)level, origin.north(), (BlockState)((BlockState)config.cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
                        } else {
                            state = level.getBlockState(origin.south());
                            if (Surface.hasSpace(state)) {
                                this.setBlock((LevelWriter)level, origin.south(), (BlockState)((BlockState)config.cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
                            } else {
                                state = level.getBlockState(origin.east());
                                if (Surface.hasSpace(state)) {
                                    this.setBlock((LevelWriter)level, origin.east(), (BlockState)((BlockState)config.cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
                                } else {
                                    state = level.getBlockState(origin.west());
                                    if (Surface.hasSpace(state)) {
                                        this.setBlock((LevelWriter)level, origin.west(), (BlockState)((BlockState)config.cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                this.setBlock((LevelWriter)level, origin, config.block);
                this.populateWithClusters(level, random, origin, config.cluster, 0.2f);
            }
            return true;
        }
        return false;
    }

    protected void populateWithClusters(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState cluster, float chance) {
        BlockState state = level.getBlockState(pos.above());
        if (Surface.hasSpace(state) && (chance == 1.0f || random.nextFloat() <= chance)) {
            this.setBlock((LevelWriter)level, pos.above(), (BlockState)((BlockState)cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
        }
        if (Surface.hasSpace(state = level.getBlockState(pos.below())) && (chance == 1.0f || random.nextFloat() <= chance)) {
            this.setBlock((LevelWriter)level, pos.below(), (BlockState)((BlockState)cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
        }
        if (Surface.hasSpace(state = level.getBlockState(pos.north())) && (chance == 1.0f || random.nextFloat() <= chance)) {
            this.setBlock((LevelWriter)level, pos.north(), (BlockState)((BlockState)cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
        }
        if (Surface.hasSpace(state = level.getBlockState(pos.south())) && (chance == 1.0f || random.nextFloat() <= chance)) {
            this.setBlock((LevelWriter)level, pos.south(), (BlockState)((BlockState)cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
        }
        if (Surface.hasSpace(state = level.getBlockState(pos.east())) && (chance == 1.0f || random.nextFloat() <= chance)) {
            this.setBlock((LevelWriter)level, pos.east(), (BlockState)((BlockState)cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
        }
        if (Surface.hasSpace(state = level.getBlockState(pos.west())) && (chance == 1.0f || random.nextFloat() <= chance)) {
            this.setBlock((LevelWriter)level, pos.west(), (BlockState)((BlockState)cluster.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.is(Blocks.WATER))));
        }
    }

    public static boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, List<RuleTest> rules) {
        return GemCluster.rule(rules, random, level.getBlockState(pos)) && (Surface.hasSpace((LevelReader)level, pos.above()) || Surface.hasSpace((LevelReader)level, pos.below()) || Surface.hasSpace((LevelReader)level, pos.north()) || Surface.hasSpace((LevelReader)level, pos.east()) || Surface.hasSpace((LevelReader)level, pos.south()) || Surface.hasSpace((LevelReader)level, pos.west()));
    }

    public static boolean rule(List<RuleTest> rules, RandomSource random, BlockState state) {
        if (rules.isEmpty() && GemCluster.standardRule(state)) {
            return true;
        }
        for (RuleTest test : rules) {
            if (!test.test(state, random)) continue;
            return true;
        }
        return false;
    }

    public static boolean standardRule(BlockState state) {
        return state.is((Block)BlockRegistry.frozenStone.get()) || state.is((Block)BlockRegistry.cobbledFrozenStone.get()) || state.is((Block)BlockRegistry.gelidite.get()) || state.is(BlockTags.ICE);
    }
}

