/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.world.feature.config.decoration.SpudConfig;
import divinerpg.world.feature.decoration.GemCluster;
import divinerpg.world.feature.decoration.Spud;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class HorizontalSpud
extends Spud {
    @Override
    public boolean place(SpudConfig config, WorldGenLevel level, ChunkGenerator c, RandomSource random, BlockPos pos) {
        if (level.ensureCanWrite(pos) && HorizontalSpud.canBeHere(level, random, pos, config.rules())) {
            config.center().ifPresent(s -> this.setBlock((LevelWriter)level, pos, (BlockState)s));
            if (config.edge().isPresent()) {
                List<RuleTest> rules = config.edgerules().orElse(config.rules());
                BlockState edge = config.edge().get();
                if (GemCluster.rule(rules, random, level.getBlockState(pos.north()))) {
                    this.setBlock((LevelWriter)level, pos.north(), (BlockState)edge.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
                }
                if (GemCluster.rule(rules, random, level.getBlockState(pos.east()))) {
                    this.setBlock((LevelWriter)level, pos.east(), (BlockState)edge.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.EAST));
                }
                if (GemCluster.rule(rules, random, level.getBlockState(pos.south()))) {
                    this.setBlock((LevelWriter)level, pos.south(), (BlockState)edge.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.SOUTH));
                }
                if (GemCluster.rule(rules, random, level.getBlockState(pos.west()))) {
                    this.setBlock((LevelWriter)level, pos.west(), (BlockState)edge.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.WEST));
                }
            }
            return true;
        }
        return false;
    }

    public static boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, List<RuleTest> rules) {
        return GemCluster.rule(rules, random, level.getBlockState(pos)) && (level.getBlockState(pos.north()).isAir() || level.getBlockState(pos.east()).isAir() || level.getBlockState(pos.south()).isAir() || level.getBlockState(pos.west()).isAir());
    }
}

