/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.decoration;

import divinerpg.world.feature.decoration.SnowCoverage;
import divinerpg.world.placement.Surface;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowSpreader
extends Feature<NoneFeatureConfiguration> {
    public SnowSpreader() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), context.chunkGenerator(), context.random(), context.origin());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        for (int x = pos.getX(); x < pos.getX() + 16; ++x) {
            for (int z = pos.getZ(); z < pos.getZ() + 16; ++z) {
                BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos(x, Surface.getSurface(Surface.Surface_Type.HIGHEST_GROUND, Surface.Mode.FULL, level.getMinBuildHeight(), level.getMaxBuildHeight(), 1, (LevelReader)level, random, x, z), z);
                BlockState state = level.getBlockState((BlockPos)position);
                double depth = 0.0;
                if (state.is(Blocks.SNOW)) {
                    depth += (double)((Integer)state.getValue((Property)BlockStateProperties.LAYERS)).intValue() * 0.125;
                    position.move(0, -1, 0);
                    state = level.getBlockState((BlockPos)position);
                }
                while (state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.POWDER_SNOW)) {
                    depth += 1.0;
                    position.move(0, -1, 0);
                    state = level.getBlockState((BlockPos)position);
                }
                position.move(0, 1, 0);
                depth /= 2.1;
                if (!(depth >= 0.125)) continue;
                this.trySnow(level, random, pos, position.north().mutable(), depth);
                this.trySnow(level, random, pos, position.south().mutable(), depth);
                this.trySnow(level, random, pos, position.east().mutable(), depth);
                this.trySnow(level, random, pos, position.west().mutable(), depth);
            }
        }
        return true;
    }

    protected void trySnow(WorldGenLevel level, RandomSource random, BlockPos origin, BlockPos.MutableBlockPos pos, double depth) {
        BlockState state;
        if (pos.getX() >> 4 == origin.getX() >> 4 && pos.getZ() >> 4 == origin.getZ() >> 4 && (state = level.getBlockState((BlockPos)pos)).is(Blocks.AIR)) {
            while ((state = level.getBlockState((BlockPos)pos.move(0, -1, 0))).isAir()) {
            }
            if (state.is(Blocks.WATER) || state.is(Blocks.BUBBLE_COLUMN) || state.getOptionalValue((Property)BlockStateProperties.WATERLOGGED).orElseGet(() -> false).booleanValue() || state.is(BlockTags.UNDERWATER_BONEMEALS) || state.is(Blocks.KELP)) {
                level.setBlock((BlockPos)pos, Blocks.ICE.defaultBlockState(), 3);
            } else {
                if (state.is(BlockTags.ICE) || !state.isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos) && !state.is(Blocks.SNOW)) {
                    return;
                }
                if (state.is(BlockTags.LEAVES)) {
                    depth -= 0.2;
                }
                if (state.hasProperty((Property)BlockStateProperties.SNOWY)) {
                    SnowCoverage.snowLog(level, pos, (BlockState)state.setValue((Property)BlockStateProperties.SNOWY, (Comparable)Boolean.valueOf(true)), new boolean[]{level.getBlockState(pos.north()).isAir(), level.getBlockState(pos.south()).isAir(), level.getBlockState(pos.east()).isAir(), level.getBlockState(pos.west()).isAir()});
                }
                if (state.is(Blocks.SNOW)) {
                    if ((depth += 0.125 * (double)((Integer)state.getValue((Property)BlockStateProperties.LAYERS)).intValue()) >= 1.0) {
                        state = depth >= 2.0 && random.nextFloat() >= 0.07f ? Blocks.POWDER_SNOW.defaultBlockState() : Blocks.SNOW_BLOCK.defaultBlockState();
                        level.setBlock((BlockPos)pos, state, 3);
                        depth -= 1.0;
                    } else {
                        level.setBlock((BlockPos)pos, (BlockState)state.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf((int)(depth * 8.0))), 3);
                        return;
                    }
                }
                pos.move(0, 1, 0);
                if (depth >= 1.0) {
                    state = depth >= 2.0 && random.nextFloat() >= 0.05f ? Blocks.POWDER_SNOW.defaultBlockState() : Blocks.SNOW_BLOCK.defaultBlockState();
                    int k = (int)depth;
                    for (int i = 0; i < k; ++i) {
                        if (!level.getBlockState((BlockPos)pos).isAir()) continue;
                        level.setBlock((BlockPos)pos, state, 3);
                        pos.move(0, 1, 0);
                    }
                    depth -= (double)k;
                }
                if (depth >= 0.125 && !state.is(Blocks.POWDER_SNOW) && level.getBlockState((BlockPos)pos).isAir()) {
                    level.setBlock((BlockPos)pos, (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf((int)(depth * 8.0))), 3);
                }
            }
        }
    }
}

