/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.plant;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.DensityFunctionConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class LandVines
extends Feature<DensityFunctionConfig> {
    public static final ResourceKey<Biome> MAGNETIC_ISLES = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"eden/magnetic_isles"));
    static BlockState vine = ((Block)BlockRegistry.landVineStem.get()).defaultBlockState();
    static BlockState northVine = (BlockState)((Block)BlockRegistry.landVine.get()).defaultBlockState().setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(true));
    static BlockState southVine = (BlockState)((Block)BlockRegistry.landVine.get()).defaultBlockState().setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(true));
    static BlockState eastVine = (BlockState)((Block)BlockRegistry.landVine.get()).defaultBlockState().setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(true));
    static BlockState westVine = (BlockState)((Block)BlockRegistry.landVine.get()).defaultBlockState().setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(true));

    public LandVines() {
        super(DensityFunctionConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<DensityFunctionConfig> context) {
        return this.place((DensityFunctionConfig)context.config(), context.level(), (ChunkGenerator)null, (RandomSource)null, context.origin());
    }

    public boolean place(DensityFunctionConfig c, WorldGenLevel level, ChunkGenerator gen, RandomSource random, BlockPos pos) {
        pos = new BlockPos(pos.getX() & 0xFFFFFFF0, 0, pos.getZ() & 0xFFFFFFF0);
        BlockPos.MutableBlockPos m = pos.mutable();
        DensityFunction df = LandVines.getWorkingDensityFunction(level.getLevel().getChunkSource().randomState(), c.function());
        for (int y = level.getMaxBuildHeight(); y >= level.getMinBuildHeight(); --y) {
            for (int x = 0; x < 16; ++x) {
                block7: for (int z = 0; z < 16; ++z) {
                    DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(pos.getX() | x, y, pos.getZ() | z);
                    if (!(0.0 <= df.compute((DensityFunction.FunctionContext)singlePointContext))) continue;
                    this.setBlock(level, (BlockPos)m.set(pos.getX() | x, y, pos.getZ() | z), ((Block)BlockRegistry.divineMossStone.get()).defaultBlockState());
                    switch (x + z & 3) {
                        case 0: {
                            this.setVine(level, m.offset(1, -1, 0));
                            this.setVine(level, m.offset(2, 0, 0));
                            this.setVine(level, m.offset(1, 1, 1));
                            continue block7;
                        }
                        case 1: {
                            this.setVine(level, m.offset(1, 2, 0));
                            this.setVine(level, m.offset(2, 1, 0));
                            this.setVine(level, m.offset(0, 1, 1));
                            continue block7;
                        }
                        case 2: {
                            this.setVine(level, m.offset(0, 2, 0));
                            this.setVine(level, m.offset(-1, 1, 0));
                            this.setVine(level, m.offset(-1, 0, 1));
                            continue block7;
                        }
                        default: {
                            this.setVine(level, m.offset(0, -1, 0));
                            this.setVine(level, m.offset(-1, 0, 0));
                            this.setVine(level, m.offset(1, 1, 1));
                        }
                    }
                }
            }
        }
        return true;
    }

    public static DensityFunction getWorkingDensityFunction(final RandomState random, DensityFunction f) {
        return f.mapAll(new DensityFunction.Visitor(){
            private final Map<DensityFunction, DensityFunction> wrapped = new HashMap<DensityFunction, DensityFunction>();

            public DensityFunction apply(DensityFunction fc) {
                return this.wrapped.computeIfAbsent(fc, function -> {
                    DensityFunction densityFunction;
                    if (function instanceof DensityFunctions.HolderHolder) {
                        Holder function1;
                        DensityFunctions.HolderHolder $b$0 = (DensityFunctions.HolderHolder)function;
                        try {
                            Holder patt1$temp;
                            function1 = patt1$temp = $b$0.function();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        densityFunction = (DensityFunction)function1.value();
                        return densityFunction;
                    }
                    if (function instanceof DensityFunctions.MarkerOrMarked) {
                        DensityFunctions.MarkerOrMarked marker = (DensityFunctions.MarkerOrMarked)function;
                        densityFunction = marker.wrapped();
                        return densityFunction;
                    }
                    densityFunction = function;
                    return densityFunction;
                });
            }

            public DensityFunction.NoiseHolder visitNoise(DensityFunction.NoiseHolder noiseHolder) {
                Holder holder = noiseHolder.noiseData();
                NormalNoise normalnoise = random.getOrCreateNoise((ResourceKey)holder.unwrapKey().orElseThrow());
                return new DensityFunction.NoiseHolder(holder, normalnoise);
            }
        });
    }

    void setVine(WorldGenLevel level, BlockPos pos) {
        this.setBlock(level, pos, vine);
        this.growVine(level, pos.north(), northVine);
        this.growVine(level, pos.south(), southVine);
        this.growVine(level, pos.east(), eastVine);
        this.growVine(level, pos.west(), westVine);
    }

    void growVine(WorldGenLevel level, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos m = pos.mutable();
        int max = 1 + level.getRandom().nextInt(5);
        for (int i = 0; i < max && this.setBlock(level, (BlockPos)m, state); ++i) {
            m.move(Direction.DOWN);
        }
        this.setBlock(level, (BlockPos)m, (BlockState)state.setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(true)));
    }

    boolean setBlock(WorldGenLevel level, BlockPos pos, BlockState state) {
        if (level.getBlockState(pos).isAir() && level.getBiome(pos).is(MAGNETIC_ISLES)) {
            level.setBlock(pos, state, 2);
            return true;
        }
        return false;
    }
}

