/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.pond;

import divinerpg.world.ConfiguredFeatureKeys;
import divinerpg.world.feature.pond.GlacialPond;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class BrittlePond
extends GlacialPond {
    @Override
    protected void genDeep(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if (random.nextFloat() < 0.15f) {
            this.setBlock((LevelWriter)level, pos.above(), Blocks.LILY_PAD.defaultBlockState());
            pos = pos.below();
            this.setBlock((LevelWriter)level, pos, Blocks.WATER.defaultBlockState());
        } else if (random.nextFloat() < 0.1f) {
            BlockState state = (BlockState)Blocks.BIG_DRIPLEAF_STEM.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            this.setBlock((LevelWriter)level, pos, state);
            this.setBlock((LevelWriter)level, pos.above(), Blocks.BIG_DRIPLEAF.defaultBlockState());
            pos = pos.below();
            this.setBlock((LevelWriter)level, pos, state);
        } else if (random.nextFloat() < 0.7f) {
            pos = pos.below();
            this.setBlock((LevelWriter)level, pos, Blocks.WATER.defaultBlockState());
        }
        this.setBlock((LevelWriter)level, pos.below(), random.nextFloat() < 0.6f ? Blocks.CLAY.defaultBlockState() : Blocks.GRAVEL.defaultBlockState());
    }

    @Override
    protected void genShallow(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if (random.nextFloat() < 0.15f) {
            this.setBlock((LevelWriter)level, pos.above(), Blocks.LILY_PAD.defaultBlockState());
        } else if (random.nextFloat() < 0.2f) {
            level.setBlock(pos, (BlockState)((BlockState)Blocks.SMALL_DRIPLEAF.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
            this.setBlock((LevelWriter)level, pos.above(), (BlockState)Blocks.SMALL_DRIPLEAF.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
        this.setBlock((LevelWriter)level, pos.below(), random.nextFloat() < 0.3f ? Blocks.MOSS_BLOCK.defaultBlockState() : Blocks.CLAY.defaultBlockState());
    }

    @Override
    protected void genEdge(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        this.setBlock((LevelWriter)level, pos, random.nextFloat() < 0.3f ? Blocks.CLAY.defaultBlockState() : Blocks.MOSS_BLOCK.defaultBlockState());
        ConfiguredFeature vegetation = (ConfiguredFeature)ConfiguredFeatureKeys.getConfiguredFeature(level, ConfiguredFeatureKeys.BRITTLE_CAVES_VEGETATION).value();
        vegetation.place(level, null, random, pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1));
        pos = pos.offset(random.nextInt(5) - 2, random.nextInt(3) - 1, random.nextInt(5) - 2);
        if (this.canSustain(rules, level, random, pos)) {
            this.setBlock((LevelWriter)level, pos, Blocks.MOSS_BLOCK.defaultBlockState());
        }
        vegetation.place(level, null, random, pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1));
        pos = pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1);
        if (this.canSustain(rules, level, random, pos)) {
            this.setBlock((LevelWriter)level, pos, Blocks.MOSS_BLOCK.defaultBlockState());
        }
        vegetation.place(level, null, random, pos.offset(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1));
    }
}

