/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.pond;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.pond.GeothermalPond;
import divinerpg.world.placement.Surface;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class GlacialPond
extends GeothermalPond {
    @Override
    protected void genDeep(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if (random.nextFloat() < 0.3f) {
            this.setBlock((LevelWriter)level, pos, Blocks.ICE.defaultBlockState());
        }
        pos = pos.below();
        this.setBlock((LevelWriter)level, pos, Blocks.WATER.defaultBlockState());
        this.genShallow(rules, level, random, pos);
    }

    @Override
    protected void genShallow(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        pos = pos.below();
        this.setBlock((LevelWriter)level, pos, random.nextFloat() < 0.8f && !Surface.hasSpace((LevelReader)level, pos.below()) ? ((Block)BlockRegistry.frozenGravel.get()).defaultBlockState() : ((Block)BlockRegistry.cobbledFrozenStone.get()).defaultBlockState());
    }

    @Override
    protected void genEdge(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if (random.nextFloat() < 0.07f) {
            this.setBlock((LevelWriter)level, pos, Blocks.WATER.defaultBlockState());
            pos = pos.below();
        }
        this.setBlock((LevelWriter)level, pos, ((Block)BlockRegistry.frozenGravel.get()).defaultBlockState());
    }

    @Override
    protected boolean canSustain(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        return this.rule(rules, random, level.getBlockState(pos)) && level.getBlockState(pos.above()).isAir() && !Surface.hasSpace(level.getBlockState(pos.below()));
    }
}

